/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.sound.ModSounds;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DarkDaggerItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public DarkDaggerItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        LivingEntity target = event.getEntity();
        if (target == null || target instanceof Player) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof DarkDaggerItem).ifPresent(result -> {
            double healthPercentage = target.m_21223_() / target.m_21233_();
            if (healthPercentage <= ModConfig.getDarkDaggerExecuteThreshold()) {
                event.setAmount((float)ModConfig.getDarkDaggerExecuteDamage());
                DarkDaggerItem.playOptimizedExecuteEffects(player, target);
            }
        }));
    }

    private static void playOptimizedExecuteEffects(Player player, LivingEntity target) {
        double z;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int particleCount = 12;
        double radius = 1.0;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = target.m_20185_() + radius * Math.cos(angle);
            z = target.m_20189_() + radius * Math.sin(angle);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, x, target.m_20186_() + 1.0, z, 1, 0.0, 0.1, 0.0, 0.05);
        }
        int riseParticleCount = 5;
        double x = target.m_20185_();
        double y = target.m_20186_();
        z = target.m_20189_();
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, x, y + 1.0, z, riseParticleCount, 0.5, 1.0, 0.5, 0.1);
        level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)ModSounds.DARK_DAGGER_EXECUTE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.bountifulbaubles.dark_dagger.effect", (Object[])new Object[]{(int)(ModConfig.getDarkDaggerExecuteThreshold() * 100.0)}).m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

