/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class DropSpindleItem
extends ModifiableBaubleItem {
    private static final Random RANDOM = new Random();
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public DropSpindleItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    DropSpindleItem.this.applyModifier(player, stack);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    DropSpindleItem.this.removeModifier(player, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        boolean hasSpindle = CuriosApi.getCuriosInventory((LivingEntity)player).resolve().flatMap(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof DropSpindleItem)).isPresent();
        if (hasSpindle && !player.m_9236_().f_46443_ && (double)RANDOM.nextFloat() < ModConfig.getDropSpindleRepairChance()) {
            EquipmentSlot[] armorSlots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
            List<ItemStack> damagedArmor = Arrays.stream(armorSlots).map(arg_0 -> ((Player)player).m_6844_(arg_0)).filter(stack -> !stack.m_41619_()).filter(stack -> stack.m_41720_() instanceof ArmorItem).filter(stack -> stack.m_41768_()).toList();
            if (!damagedArmor.isEmpty()) {
                ItemStack armorToRepair = damagedArmor.get(RANDOM.nextInt(damagedArmor.size()));
                int repairAmount = Math.min(ModConfig.getDropSpindleRepairAmount(), armorToRepair.m_41773_());
                armorToRepair.m_41721_(armorToRepair.m_41773_() - repairAmount);
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.bountifulbaubles.dropspindle.effects", (Object[])new Object[]{ModConfig.getDropSpindleRepairChance() * 100.0, ModConfig.getDropSpindleRepairAmount()}).m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

