/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class FireMindItem
extends ModifiableBaubleItem {
    private static final double RANGE = 10.0;
    private static final int FIRE_DURATION = 3;
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public FireMindItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    FireMindItem.this.applyModifier(player, stack);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    FireMindItem.this.removeModifier(player, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        boolean hasFireMind;
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().f_46443_ && (hasFireMind = CuriosApi.getCuriosInventory((LivingEntity)(player = event.player)).resolve().flatMap(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof FireMindItem)).isPresent())) {
            Vec3 lookVec = player.m_20154_();
            Vec3 eyePos = player.m_146892_();
            AABB searchBox = player.m_20191_().m_82400_(10.0);
            List entities = player.m_9236_().m_45933_((Entity)player, searchBox);
            for (Entity target : entities) {
                BlockHitResult result;
                double dot;
                Vec3 toTarget;
                double distance;
                if (!(target instanceof LivingEntity) || target == player || target.m_20094_() > 0 || !((distance = (toTarget = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0).m_82546_(eyePos)).m_82553_()) <= 10.0) || !((dot = toTarget.m_82541_().m_82526_(lookVec)) > 0.98) || (result = player.m_9236_().m_45547_(new ClipContext(eyePos, target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player))).m_6662_() != HitResult.Type.MISS && !(result.m_82450_().m_82557_(eyePos) > distance * distance)) continue;
                target.m_20254_(3);
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.fire_mind.effects").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

