/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class GauntletsOfDexterityItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();
    private static final UUID FIXED_ATTACK_SPEED_UUID = UUID.fromString("6a3e4d5b-1c2d-4f8a-9e7f-0d3a2b1c4d5e");

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public GauntletsOfDexterityItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void applyModifier(Player player, ItemStack stack) {
        super.applyModifier(player, stack);
        double fixedValue = ModConfig.getGauntletsAttackSpeed();
        AttributeInstance attr = player.m_21051_(Attributes.f_22283_);
        if (attr == null) {
            return;
        }
        AttributeModifier existing = attr.m_22111_(FIXED_ATTACK_SPEED_UUID);
        if (existing == null) {
            attr.m_22125_(this.createFixedModifier(fixedValue));
        } else if (existing.m_22218_() != fixedValue) {
            attr.m_22120_(FIXED_ATTACK_SPEED_UUID);
            attr.m_22125_(this.createFixedModifier(fixedValue));
        }
    }

    @Override
    public void removeModifier(Player player, ItemStack stack) {
        AttributeInstance attr;
        super.removeModifier(player, stack);
        if (!this.hasSameItemEquipped(player) && (attr = player.m_21051_(Attributes.f_22283_)) != null) {
            attr.m_22120_(FIXED_ATTACK_SPEED_UUID);
        }
    }

    private AttributeModifier createFixedModifier(double value) {
        return new AttributeModifier(FIXED_ATTACK_SPEED_UUID, "bountifulbaubles.fixed_attack_speed", value, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    private boolean hasSameItemEquipped(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).resolve().map(handler -> {
            int count = 0;
            for (String identifier : handler.getCurios().keySet()) {
                ICurioStacksHandler stackHandler = (ICurioStacksHandler)handler.getCurios().get(identifier);
                if (stackHandler == null) continue;
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStacks().getStackInSlot(i);
                    if (!(stack.m_41720_() instanceof GauntletsOfDexterityItem) || ++count < 2) continue;
                    return true;
                }
            }
            return count >= 2;
        }).orElse(false);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        double speed = ModConfig.getGauntletsAttackSpeed() * 100.0;
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.gauntlets_of_dexterity.effect").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

