/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class MossyRingItem
extends ModifiableBaubleItem {
    private static final String REPAIR_TIMER_KEY = "RepairTimer";
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public MossyRingItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_) {
                CompoundTag tag = stack.m_41784_();
                int timer = tag.m_128451_(REPAIR_TIMER_KEY);
                if (timer >= ModConfig.getMossyRingRepairInterval()) {
                    if (this.repairItem(player)) {
                        tag.m_128405_(REPAIR_TIMER_KEY, 0);
                    } else {
                        ++timer;
                    }
                } else {
                    tag.m_128405_(REPAIR_TIMER_KEY, timer + 1);
                }
            }
        }
    }

    private boolean repairItem(Player player) {
        ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
        if (this.canRepair(mainHand)) {
            this.repairSingleItem(mainHand, player);
            return true;
        }
        ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
        if (this.canRepair(offHand)) {
            this.repairSingleItem(offHand, player);
            return true;
        }
        return false;
    }

    private boolean canRepair(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41768_() && stack.m_41720_().m_41465_();
    }

    private void repairSingleItem(ItemStack stack, Player player) {
        int repairAmount = Math.min(ModConfig.getMossyRingRepairAmount(), stack.m_41773_());
        stack.m_41721_(stack.m_41773_() - repairAmount);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.bountifulbaubles.mossyring.effects", (Object[])new Object[]{Float.valueOf((float)ModConfig.getMossyRingRepairInterval() / 20.0f), ModConfig.getMossyRingRepairAmount()}).m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.mossyring.description").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

