/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class PhylacteryCharmItem
extends ModifiableBaubleItem {
    private static final UUID PHYLACTERY_UUID = UUID.fromString("bba5e6f7-b8c9-d0e1-f2a3-b4c5d6e7f8a9");
    private static final String DATA_KEY = "phylactery_loss";
    private static final float TELEPORT_COST = 6.0f;
    private static final int COOLDOWN_TICKS = 0;
    private static final int USE_DURATION = 1;
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public PhylacteryCharmItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_36335_().m_41519_((Item)this)) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_6469_(player.m_269291_().m_269425_(), 6.0f);
            PhylacteryCharmItem.performTeleport(player);
            player.m_36335_().m_41524_((Item)this, 0);
        }
        return stack;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (ModList.get().isLoaded("firstaid")) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (!event.isCanceled() && PhylacteryCharmItem.isEquipped((LivingEntity)player)) {
                PhylacteryCharmItem.handleDamageProtection(player, event);
            }
        }
    }

    private static void handleDamageProtection(ServerPlayer player, LivingHurtEvent event) {
        float damageAmount;
        float effectiveHealth = player.m_21223_() + player.m_6103_();
        if (effectiveHealth <= (damageAmount = event.getAmount())) {
            float overflowDamage = damageAmount - effectiveHealth;
            float adjustedDamage = overflowDamage <= 1.0f ? 1.0f : overflowDamage;
            AttributeInstance maxHealthAttr = player.m_21051_(Attributes.f_22276_);
            if (maxHealthAttr == null) {
                return;
            }
            float currentMax = (float)maxHealthAttr.m_22135_();
            if (currentMax > adjustedDamage) {
                event.setCanceled(true);
                player.m_7911_(0.0f);
                player.m_21153_(1.0f);
                CompoundTag data = player.getPersistentData();
                float totalLoss = data.m_128457_(DATA_KEY);
                data.m_128350_(DATA_KEY, totalLoss += adjustedDamage);
                PhylacteryCharmItem.updateHealthModifier((Player)player, maxHealthAttr, totalLoss);
                PhylacteryCharmItem.performTeleport(player);
                PhylacteryCharmItem.triggerAttributeSync((Player)player);
            }
        }
    }

    private static void updateHealthModifier(Player player, AttributeInstance maxHealthAttr, float totalLoss) {
        maxHealthAttr.m_22120_(PHYLACTERY_UUID);
        maxHealthAttr.m_22125_(new AttributeModifier(PHYLACTERY_UUID, "phylactery_penalty", (double)(-totalLoss), AttributeModifier.Operation.ADDITION));
    }

    public static void performTeleport(ServerPlayer player) {
        ServerLevel targetLevel = player.f_8924_.m_129880_(player.m_8963_());
        BlockPos spawnPos = player.m_8961_();
        if (spawnPos == null || targetLevel == null) {
            targetLevel = player.f_8924_.m_129783_();
            spawnPos = targetLevel.m_220360_();
        }
        player.m_8999_(targetLevel, (double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 0.1, (double)spawnPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
        player.f_19789_ = 0.0f;
        PhylacteryCharmItem.triggerAttributeSync((Player)player);
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 0.8f);
        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123760_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 100, 0.5, 0.5, 0.5, 0.1);
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        if (ModList.get().isLoaded("firstaid")) {
            if (player.m_21051_(Attributes.f_22276_).m_22111_(PHYLACTERY_UUID) != null) {
                player.m_21051_(Attributes.f_22276_).m_22120_(PHYLACTERY_UUID);
            }
            return;
        }
        if (!player.m_9236_().f_46443_ && player.m_36317_() && PhylacteryCharmItem.isEquipped((LivingEntity)player)) {
            PhylacteryCharmItem.handleHealthRecovery(player);
            PhylacteryCharmItem.triggerAttributeSync(player);
        }
    }

    private static void handleHealthRecovery(Player player) {
        AttributeInstance maxHealthAttr;
        CompoundTag data = player.getPersistentData();
        float totalLoss = data.m_128457_(DATA_KEY);
        if (totalLoss > 0.0f && (maxHealthAttr = player.m_21051_(Attributes.f_22276_)) != null) {
            maxHealthAttr.m_22120_(PHYLACTERY_UUID);
            double baseMaxHealth = maxHealthAttr.m_22135_();
            float recovery = Math.min(totalLoss, 4.0f);
            data.m_128350_(DATA_KEY, totalLoss -= recovery);
            if (totalLoss > 0.0f) {
                maxHealthAttr.m_22125_(new AttributeModifier(PHYLACTERY_UUID, "phylactery_penalty", (double)(-totalLoss), AttributeModifier.Operation.ADDITION));
            }
            float newMaxHealth = (float)maxHealthAttr.m_22135_();
            float currentHealth = player.m_21223_();
            if (currentHealth < newMaxHealth) {
                player.m_21153_(Math.min(currentHealth + recovery, newMaxHealth));
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_240418_((Component)Component.m_237113_((String)("Restored " + recovery + " max health")).m_130940_(ChatFormatting.GREEN), false);
                serverPlayer.m_240418_((Component)Component.m_237113_((String)("Current max health: " + String.format("%.1f", Float.valueOf(newMaxHealth)))).m_130940_(ChatFormatting.GRAY), false);
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.2f);
            }
            PhylacteryCharmItem.triggerAttributeSync(player);
        }
    }

    public static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(curios -> curios.findFirstCurio(stack -> stack.m_41720_() instanceof PhylacteryCharmItem)).isPresent();
    }

    public int m_8105_(ItemStack stack) {
        return 1;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.TOOT_HORN;
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    PhylacteryCharmItem.this.applyModifier(player, stack);
                    PhylacteryCharmItem.triggerAttributeSync(player);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    PhylacteryCharmItem.this.removeModifier(player, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }

            public void curioTick(SlotContext slotContext) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.m_36335_().m_41527_((Item)PhylacteryCharmItem.this);
                    if (!player.m_9236_().m_5776_()) {
                        float maxHealth = player.m_21233_();
                        float currentHealth = player.m_21223_();
                        if (currentHealth > maxHealth) {
                            player.m_21153_(maxHealth);
                            if (player.f_19797_ % 2 == 0) {
                                PhylacteryCharmItem.triggerAttributeSync(player);
                            }
                        }
                    }
                }
            }
        });
    }

    private static void triggerAttributeSync(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            List<AttributeInstance> attributes = List.of(serverPlayer.m_21051_(Attributes.f_22276_));
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundUpdateAttributesPacket(serverPlayer.m_19879_(), attributes));
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.phylactery_charm.effect").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

