/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.effect.ModEffects;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class PridePendantItem
extends ModifiableBaubleItem {
    private static final double STEP_HEIGHT_BONUS = 0.6;
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public PridePendantItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    PridePendantItem.this.applyModifier(player, stack);
                    PridePendantItem.this.applyStepHeight(player);
                    PridePendantItem.this.checkSinfulEffect(player);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    PridePendantItem.this.removeModifier(player, stack);
                    PridePendantItem.this.removeStepHeight(player);
                    player.m_21195_((MobEffect)ModEffects.SINFUL.get());
                }
            }

            public void curioTick(SlotContext slotContext) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    PridePendantItem.this.handleSinfulEffect(player);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    private void handleSinfulEffect(Player player) {
        if (player.m_21223_() >= player.m_21233_()) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SINFUL.get(), 40, 0, false, true, true));
        } else {
            player.m_21195_((MobEffect)ModEffects.SINFUL.get());
        }
    }

    private void checkSinfulEffect(Player player) {
        if (player.m_21223_() >= player.m_21233_()) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SINFUL.get(), 40, 0, false, true, true));
        }
    }

    private void applyStepHeight(Player player) {
        AttributeInstance stepHeight = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        if (stepHeight != null) {
            stepHeight.m_22100_(0.6);
        }
    }

    private void removeStepHeight(Player player) {
        AttributeInstance stepHeight = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        if (stepHeight != null) {
            stepHeight.m_22100_(0.0);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.pride_pendant.effect").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.pride_pendant.effect1").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }
}

