/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class RubyHeartItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public RubyHeartItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    RubyHeartItem.this.applyModifier(player, stack);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    RubyHeartItem.this.removeModifier(player, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        boolean hasRubyHeart = CuriosApi.getCuriosInventory((LivingEntity)player).resolve().flatMap(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof RubyHeartItem)).map(found -> {
            ItemStack rubyHeart = found.stack();
            RubyHeartItem.handleDamageProtection(event, player, rubyHeart);
            return true;
        }).orElse(false);
    }

    private static void handleDamageProtection(LivingDamageEvent event, Player player, ItemStack rubyHeart) {
        float currentHealthPercent = player.m_21223_() / player.m_21233_();
        if ((double)currentHealthPercent <= (Double)ModConfig.RUBY_HEART_HEALTH_THRESHOLD.get()) {
            return;
        }
        if (player.m_36335_().m_41519_(rubyHeart.m_41720_())) {
            return;
        }
        float damageAmount = event.getAmount();
        float healthAfterDamage = player.m_21223_() - damageAmount;
        if (healthAfterDamage <= 0.0f) {
            event.setCanceled(true);
            player.m_21153_(1.0f);
            player.m_36335_().m_41524_(rubyHeart.m_41720_(), (Integer)ModConfig.RUBY_HEART_COOLDOWN.get() * 20);
            player.m_5661_((Component)Component.m_237115_((String)"message.bountifulbaubles.ruby_heart.activated").m_130940_(ChatFormatting.RED), true);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.ruby_heart.effect").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.bountifulbaubles.ruby_heart.threshold", (Object[])new Object[]{String.format("%.0f", (Double)ModConfig.RUBY_HEART_HEALTH_THRESHOLD.get() * 100.0)}).m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.bountifulbaubles.ruby_heart.cooldown", (Object[])new Object[]{ModConfig.RUBY_HEART_COOLDOWN.get()}).m_130940_(ChatFormatting.DARK_GREEN));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

