/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.BountifulBaublesMod;
import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class TreasureBagItem
extends Item {
    private static final Random RANDOM = new Random();
    private static List<WeightedItem> possibleItems = null;

    public TreasureBagItem(Item.Properties properties) {
        super(properties);
    }

    private void initPossibleItems() {
        if (possibleItems == null) {
            possibleItems = new ArrayList<WeightedItem>();
            try {
                String[] configItems;
                for (String entry : configItems = ((String)ModConfig.TREASURE_BAG_ITEMS.get()).split(";")) {
                    try {
                        String[] parts = entry.trim().split(",");
                        if (parts.length != 2) {
                            BountifulBaublesMod.LOGGER.error("Invalid format in treasure bag config: " + entry);
                            continue;
                        }
                        String itemId = parts[0].trim();
                        int weight = Integer.parseInt(parts[1].trim());
                        ResourceLocation resourceLocation = new ResourceLocation(itemId);
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                        if (item != null) {
                            possibleItems.add(new WeightedItem((RegistryObject<Item>)RegistryObject.create((ResourceLocation)resourceLocation, (IForgeRegistry)ForgeRegistries.ITEMS), weight));
                            continue;
                        }
                        BountifulBaublesMod.LOGGER.error("Item not found in registry: " + itemId);
                    }
                    catch (NumberFormatException e) {
                        BountifulBaublesMod.LOGGER.error("Invalid weight in treasure bag config: " + entry);
                    }
                    catch (Exception e) {
                        BountifulBaublesMod.LOGGER.error("Invalid item entry in treasure bag config: " + entry);
                    }
                }
            }
            catch (Exception e) {
                BountifulBaublesMod.LOGGER.error("Error loading treasure bag config", (Throwable)e);
            }
        }
    }

    private RegistryObject<Item> getRandomItem() {
        if (possibleItems == null || possibleItems.isEmpty()) {
            return null;
        }
        int totalWeight = possibleItems.stream().mapToInt(item -> item.weight).sum();
        int randomWeight = RANDOM.nextInt(totalWeight);
        int currentWeight = 0;
        for (WeightedItem weightedItem : possibleItems) {
            if (randomWeight >= (currentWeight += weightedItem.weight)) continue;
            return weightedItem.item;
        }
        return TreasureBagItem.possibleItems.get((int)(TreasureBagItem.possibleItems.size() - 1)).item;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!level.f_46443_) {
            this.initPossibleItems();
            if (possibleItems != null && !possibleItems.isEmpty()) {
                RegistryObject<Item> randomItem = this.getRandomItem();
                if (randomItem != null) {
                    ItemStack rewardStack = new ItemStack((ItemLike)randomItem.get());
                    if (!player.m_150109_().m_36054_(rewardStack)) {
                        player.m_36176_(rewardStack, false);
                    }
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_184214_, SoundSource.PLAYERS, 0.5f, 1.0f);
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                }
            } else {
                BountifulBaublesMod.LOGGER.error("Treasure bag has no possible items configured!");
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.treasure_bag").m_130940_(ChatFormatting.BLUE));
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    private static class WeightedItem {
        final RegistryObject<Item> item;
        final int weight;

        WeightedItem(RegistryObject<Item> item, int weight) {
            this.item = item;
            this.weight = weight;
        }
    }
}

