/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.network.handler;

import com.jinqinxixi.bountifulbaubles.network.handler.ClientPacketHandler;
import com.jinqinxixi.bountifulbaubles.network.packet.MarkTargetPacket;
import com.jinqinxixi.bountifulbaubles.network.packet.SpawnParticlesPacket;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "2.0";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("bountifulbaubles", "main_channel"), () -> "2.0", "2.0"::equals, "2.0"::equals);
    private static int packetId = 0;

    public static void registerPackets() {
        NetworkHandler.registerCommonPackets();
    }

    private static void registerCommonPackets() {
        CHANNEL.registerMessage(packetId++, DoubleJumpPacket.class, DoubleJumpPacket::encode, DoubleJumpPacket::new, DoubleJumpPacket::handle);
        CHANNEL.registerMessage(packetId++, InfiniteTotemCooldownPacket.class, InfiniteTotemCooldownPacket::encode, InfiniteTotemCooldownPacket::new, InfiniteTotemCooldownPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(packetId++, TotemParticlesPacket.class, TotemParticlesPacket::encode, TotemParticlesPacket::new, TotemParticlesPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(packetId++, MarkTargetPacket.class, MarkTargetPacket::encode, MarkTargetPacket::new, MarkTargetPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(packetId++, SpawnParticlesPacket.class, SpawnParticlesPacket::encode, SpawnParticlesPacket::new, SpawnParticlesPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static class DoubleJumpPacket {
        private final boolean withParticles;

        public DoubleJumpPacket(boolean withParticles) {
            this.withParticles = withParticles;
        }

        public DoubleJumpPacket(FriendlyByteBuf buf) {
            this.withParticles = buf.readBoolean();
        }

        public void encode(FriendlyByteBuf buf) {
            buf.writeBoolean(this.withParticles);
        }

        public static void handle(DoubleJumpPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender;
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer() && (sender = ((NetworkEvent.Context)ctx.get()).getSender()) != null && msg.withParticles) {
                    SpawnParticlesPacket particlesPacket = new SpawnParticlesPacket(sender.m_19879_());
                    CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)particlesPacket);
                    CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> sender), (Object)particlesPacket);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class InfiniteTotemCooldownPacket {
        final int cooldown;

        public InfiniteTotemCooldownPacket(int cooldown) {
            this.cooldown = cooldown;
        }

        public InfiniteTotemCooldownPacket(FriendlyByteBuf buf) {
            this.cooldown = buf.readInt();
        }

        public void encode(FriendlyByteBuf buf) {
            buf.writeInt(this.cooldown);
        }

        public static void handle(InfiniteTotemCooldownPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                    DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleInfiniteTotemCooldown(packet));
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public static void sendToClient(ServerPlayer player, int cooldown) {
            CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new InfiniteTotemCooldownPacket(cooldown));
        }
    }

    public static class TotemParticlesPacket {
        private final double x;
        private final double y;
        private final double z;

        public TotemParticlesPacket(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public TotemParticlesPacket(FriendlyByteBuf buf) {
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
        }

        public void encode(FriendlyByteBuf buf) {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
        }

        public static void handle(TotemParticlesPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                    DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.spawnTotemParticles(packet.x, packet.y, packet.z));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

