/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles;

import com.jinqinxixi.bountifulbaubles.ClientProxy;
import com.jinqinxixi.bountifulbaubles.compat.firstaid.BrokenHeartFirstAidCompat;
import com.jinqinxixi.bountifulbaubles.compat.firstaid.PhylacteryCharmFirstAidCompat;
import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.item.Baubles.BottledCloudItem;
import com.jinqinxixi.bountifulbaubles.item.Baubles.WormholeMirrorItem;
import com.jinqinxixi.bountifulbaubles.item.ModCreativeModeTab;
import com.jinqinxixi.bountifulbaubles.item.ModItems;
import com.jinqinxixi.bountifulbaubles.loot.LootHandler;
import com.jinqinxixi.bountifulbaubles.network.handler.NetworkHandler;
import com.jinqinxixi.bountifulbaubles.sound.ModSounds;
import com.jinqinxixi.bountifulbaubles.system.effect.ModEffects;
import com.jinqinxixi.bountifulbaubles.system.recast.AnvilRecastRegistry;
import com.jinqinxixi.bountifulbaubles.system.recast.ModBrewingRecipes;
import com.jinqinxixi.bountifulbaubles.system.recast.RecastRegistry;
import com.jinqinxixi.bountifulbaubles.system.wormhole.PacketHandler;
import com.jinqinxixi.bountifulbaubles.system.wormhole.TeleportRequestManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.slf4j.Logger;

@Mod(value="bountifulbaubles")
public class BountifulBaublesMod {
    public static final String MOD_ID = "bountifulbaubles";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"bountifulbaubles");

    public BountifulBaublesMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherData);
        modEventBus.addListener(this::onCommonSetup);
        PacketHandler.register();
        ModSounds.SOUND_EVENTS.register(modEventBus);
        ModItems.register(modEventBus);
        ModCreativeModeTab.register(modEventBus);
        ModEffects.EFFECTS.register(modEventBus);
        PacketHandler.register();
        NetworkHandler.registerPackets();
        MinecraftForge.EVENT_BUS.register((Object)new LootHandler());
        MinecraftForge.EVENT_BUS.register(BottledCloudItem.class);
        MinecraftForge.EVENT_BUS.register(AnvilRecastRegistry.class);
        ModBrewingRecipes.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.SPEC, "bountifulbaubles-common.toml");
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientProxy.init();
        }
        if (ModList.get().isLoaded("firstaid")) {
            MinecraftForge.EVENT_BUS.register(BrokenHeartFirstAidCompat.class);
            MinecraftForge.EVENT_BUS.register(PhylacteryCharmFirstAidCompat.class);
        }
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModConfig.loadLootConfig();
            AnvilRecastRegistry.registerAllRecipes();
            LOGGER.info("[Bountiful Baubles] Common setup completed");
        });
    }

    @SubscribeEvent
    public void onGatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new RecastRegistry(output));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)MOD_ID).requires(source -> source.m_6761_(0))).then(Commands.m_82127_((String)"tp_accept").then(Commands.m_82129_((String)"requestId", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.handleTeleportResponse((CommandContext<CommandSourceStack>)ctx, true))))).then(Commands.m_82127_((String)"tp_deny").then(Commands.m_82129_((String)"requestId", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.handleTeleportResponse((CommandContext<CommandSourceStack>)ctx, false)))));
    }

    private int handleTeleportResponse(CommandContext<CommandSourceStack> ctx, boolean accept) {
        try {
            String requestIdStr = StringArgumentType.getString(ctx, (String)"requestId");
            UUID requestId = UUID.fromString(requestIdStr);
            ServerPlayer responder = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (responder == null) {
                return 0;
            }
            TeleportRequestManager.TeleportRequest request = TeleportRequestManager.getRequest(requestId);
            if (request == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"msg.mirror.invalid_request"));
                return 0;
            }
            TeleportRequestManager.removeRequest(requestId);
            if (accept) {
                request.requester.m_8999_(responder.m_284548_(), responder.m_20185_(), responder.m_20186_(), responder.m_20189_(), responder.m_146908_(), responder.m_146909_());
                ((WormholeMirrorItem)((Object)ModItems.WORMHOLE_MIRROR.get())).playTeleportEffects(request.requester);
                this.sendTeleportMessages(request.requester, responder, true);
            } else {
                this.sendTeleportMessages(request.requester, responder, false);
            }
            return 1;
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"msg.mirror.invalid_request"));
            return 0;
        }
    }

    private void sendTeleportMessages(ServerPlayer requester, ServerPlayer responder, boolean accepted) {
        MutableComponent requesterMsg = accepted ? Component.m_237110_((String)"msg.mirror.request_accepted", (Object[])new Object[]{responder.m_6302_()}) : Component.m_237110_((String)"msg.mirror.request_denied", (Object[])new Object[]{responder.m_6302_()});
        MutableComponent responderMsg = accepted ? Component.m_237110_((String)"msg.mirror.accepted", (Object[])new Object[]{requester.m_6302_()}) : Component.m_237110_((String)"msg.mirror.denied", (Object[])new Object[]{requester.m_6302_()});
        requester.m_213846_((Component)requesterMsg);
        responder.m_213846_((Component)responderMsg);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> LOGGER.info("[Bountiful Baubles] Brewing recipes registered"));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        float maxHealth;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        float currentHealth = player.m_21223_();
        if (currentHealth > (maxHealth = player.m_21233_())) {
            player.m_6469_(player.m_269291_().m_269264_(), 0.0f);
            player.m_21153_(maxHealth);
        } else if (Math.abs(currentHealth - player.m_21223_()) > 0.01f) {
            player.m_6469_(player.m_269291_().m_269264_(), 0.0f);
            player.m_21153_(currentHealth);
        }
    }

    static class ClientEvents {
        ClientEvents() {
        }

        public static void onGuiOpen(ScreenEvent.Init.Post event) {
        }
    }

    @Mod.EventBusSubscriber(modid="bountifulbaubles", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                ItemPropertyFunction blockFn = (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f;
                ItemProperties.register((Item)((Item)ModItems.COBALT_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (ItemPropertyFunction)blockFn);
                ItemProperties.register((Item)((Item)ModItems.OBSIDIAN_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (ItemPropertyFunction)blockFn);
                ItemProperties.register((Item)((Item)ModItems.ANKH_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (ItemPropertyFunction)blockFn);
                LOGGER.info("[Bountiful Baubles] Client setup completed");
            });
        }
    }
}

