/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.client.render;

import com.jinqinxixi.bountifulbaubles.item.Baubles.MindsEyeItem;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bountifulbaubles", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class MarkerRenderer {
    private static final ResourceLocation MARKER_TEXTURE = new ResourceLocation("bountifulbaubles", "textures/misc/target_marker.png");
    private static final float MARKER_SIZE = 0.5f;

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        float partialTicks = event.getPartialTick();
        PoseStack poseStack = event.getPoseStack();
        for (Map.Entry<UUID, Map.Entry<Integer, Long>> entry : MindsEyeItem.getMarkedTargets().entrySet()) {
            Entity target = mc.f_91073_.m_6815_(entry.getValue().getKey().intValue());
            if (target == null) continue;
            double interpEntityX = target.f_19854_ + (target.m_20185_() - target.f_19854_) * (double)partialTicks;
            double interpEntityY = target.f_19855_ + (target.m_20186_() - target.f_19855_) * (double)partialTicks;
            double interpEntityZ = target.f_19856_ + (target.m_20189_() - target.f_19856_) * (double)partialTicks;
            double entityHeight = target.m_20206_();
            Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
            poseStack.m_85836_();
            poseStack.m_85837_(interpEntityX - cameraPos.f_82479_, interpEntityY + entityHeight + 0.7 - cameraPos.f_82480_, interpEntityZ - cameraPos.f_82481_);
            poseStack.m_252781_(mc.f_91063_.m_109153_().m_253121_());
            MarkerRenderer.renderMarker(poseStack);
            poseStack.m_85849_();
        }
    }

    private static void renderMarker(PoseStack poseStack) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MARKER_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        float halfSize = 0.25f;
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize, -halfSize, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize, halfSize, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), halfSize, halfSize, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), halfSize, -halfSize, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        tesselator.m_85914_();
    }
}

