/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.compat.firstaid;

import com.jinqinxixi.bountifulbaubles.item.Baubles.PhylacteryCharmItem;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.event.FirstAidLivingDamageEvent;
import ichttt.mods.firstaid.common.network.MessageUpdatePart;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;

public class PhylacteryCharmFirstAidCompat {
    public static final String FIRSTAID_MODID = "firstaid";
    private static final UUID PHYLACTERY_UUID = UUID.fromString("bba5e6f7-b8c9-d0e1-f2a3-b4c5d6e7f8a9");

    public static boolean isLoaded() {
        return ModList.get().isLoaded(FIRSTAID_MODID);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onFirstAidLivingDamageLow(FirstAidLivingDamageEvent event) {
        if (event.getEntity() == null || event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (event.getUndistributedDamage() > 1000.0f) {
            return;
        }
        if (!PhylacteryCharmItem.isEquipped((LivingEntity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        boolean failed = false;
        ArrayList<AbstractDamageablePart> parts = new ArrayList<AbstractDamageablePart>();
        for (AbstractDamageablePart part : event.getAfterDamage()) {
            if (!part.canCauseDeath || !(part.currentHealth <= 0.0f)) continue;
            if (part.getMaxHealth() >= 4) {
                parts.add(part);
                continue;
            }
            failed = true;
        }
        if (!failed && !parts.isEmpty()) {
            AttributeInstance maxHealth = player.m_21051_(Attributes.f_22276_);
            AttributeModifier modifier = maxHealth.m_22111_(PHYLACTERY_UUID);
            double prevMaxHealthDamage = 0.0;
            if (modifier != null) {
                prevMaxHealthDamage = modifier.m_22218_();
            }
            double curMaxHealth = maxHealth.m_22115_();
            for (AttributeModifier mod : maxHealth.m_22104_(AttributeModifier.Operation.ADDITION)) {
                curMaxHealth += mod.m_22218_();
            }
            double originalMaxHealth = curMaxHealth - prevMaxHealthDamage;
            double healthToRemove = originalMaxHealth * 0.3 + (double)(parts.size() * 2) + (double)event.getUndistributedDamage();
            if (healthToRemove > curMaxHealth - 2.0) {
                return;
            }
            for (AbstractDamageablePart part : parts) {
                part.heal(1.0f, null, false);
                if (!(event.getEntity() instanceof ServerPlayer)) continue;
                FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageUpdatePart(part));
            }
            if (modifier != null) {
                maxHealth.m_22130_(modifier);
            }
            modifier = new AttributeModifier(PHYLACTERY_UUID, "Phylactery MaxHP drain", prevMaxHealthDamage - healthToRemove, AttributeModifier.Operation.ADDITION);
            maxHealth.m_22125_(modifier);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PhylacteryCharmItem.performTeleport(serverPlayer);
            }
        }
    }
}

