/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class BlackDragonScaleItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();
    private static final MobEffect[] BLOCKED_EFFECTS = new MobEffect[]{MobEffects.f_19615_};

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public BlackDragonScaleItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity entity = slotContext.entity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    BlackDragonScaleItem.this.applyModifier(player, stack);
                    BlackDragonScaleItem.clearBlockedEffects(player);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity entity = slotContext.entity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    BlackDragonScaleItem.this.removeModifier(player, stack);
                    this.updateEffectState(player);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            private void updateEffectState(Player player) {
                MobEffectInstance wither;
                boolean hasScale = CuriosApi.getCuriosInventory((LivingEntity)player).resolve().map(curios -> curios.findFirstCurio(stack -> stack.m_41720_() instanceof BlackDragonScaleItem).isPresent()).orElse(false);
                if (!hasScale && player.m_21023_(MobEffects.f_19615_) && (wither = player.m_21124_(MobEffects.f_19615_)) != null) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, wither.m_19557_(), wither.m_19564_(), wither.m_19571_(), wither.m_19572_(), wither.m_19575_()));
                }
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEffectApplicable(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MobEffectInstance effect = event.getEffectInstance();
            if (effect != null && BlackDragonScaleItem.isBlockedEffect(effect.m_19544_())) {
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curios -> {
                    if (curios.findFirstCurio(stack -> stack.m_41720_() instanceof BlackDragonScaleItem).isPresent()) {
                        event.setResult(Event.Result.DENY);
                        BlackDragonScaleItem.clearBlockedEffects(player);
                    }
                });
            }
        }
    }

    private static void clearBlockedEffects(Player player) {
        for (MobEffect effect : BLOCKED_EFFECTS) {
            player.m_21195_(effect);
        }
    }

    private static boolean isBlockedEffect(MobEffect effect) {
        for (MobEffect blocked : BLOCKED_EFFECTS) {
            if (effect != blocked) continue;
            return true;
        }
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.black_dragon_scale.effect").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

