/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.network.handler.NetworkHandler;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber
public class BottledCloudItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public BottledCloudItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public static void jump(Player player) {
        player.f_19789_ = 0.0f;
        double upwardsMotion = 0.5;
        if (player.m_21023_(MobEffects.f_19603_)) {
            upwardsMotion += 0.1 * (double)(player.m_21124_(MobEffects.f_19603_).m_19564_() + 1);
        }
        if (player.m_20142_()) {
            upwardsMotion *= 1.0 + (Double)ModConfig.SPRINT_JUMP_VERTICAL.get();
        }
        Vec3 currentMotion = player.m_20184_();
        float yaw = player.m_146908_() * ((float)Math.PI / 180);
        double horizontalBoost = player.m_20142_() ? (Double)ModConfig.SPRINT_JUMP_HORIZONTAL.get() : 0.0;
        Vec3 addedMotion = new Vec3((double)(-Mth.m_14031_((float)yaw)) * horizontalBoost, upwardsMotion - currentMotion.f_82480_, (double)Mth.m_14089_((float)yaw) * horizontalBoost);
        player.m_20256_(currentMotion.m_82549_(addedMotion));
        player.f_19812_ = true;
        player.m_36220_(Stats.f_12926_);
        if (player.m_20142_()) {
            player.m_36399_(0.2f);
        } else {
            player.m_36399_(0.05f);
        }
        player.m_5496_(SoundEvents.f_12640_, 1.0f, 0.9f + player.m_217043_().m_188501_() * 0.2f);
        NetworkHandler.CHANNEL.sendToServer((Object)new NetworkHandler.DoubleJumpPacket(true));
        if (player.m_9236_().f_46443_) {
            BottledCloudItem.spawnJumpParticles(player);
        }
    }

    public static void spawnJumpParticles(Player player) {
        Vec3 pos = player.m_20182_();
        RandomSource random = player.m_217043_();
        for (int i = 0; i < 8; ++i) {
            double dx = random.m_188583_() * 0.02;
            double dy = random.m_188583_() * 0.02 + 0.2;
            double dz = random.m_188583_() * 0.02;
            player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, pos.f_82479_ + (double)random.m_188501_() * 0.6 - 0.3, pos.f_82480_, pos.f_82481_ + (double)random.m_188501_() * 0.6 - 0.3, dx, dy, dz);
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && BottledCloudItem.hasBottledCloud((LivingEntity)(player = (Player)livingEntity))) {
            event.setDistance(Math.max(0.0f, event.getDistance() - 3.0f));
        }
    }

    public static boolean hasBottledCloud(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().map(handler -> {
            for (String identifier : handler.getCurios().keySet()) {
                ICurioStacksHandler stackHandler = (ICurioStacksHandler)handler.getCurios().get(identifier);
                if (stackHandler == null) continue;
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    if (!(stackHandler.getStacks().getStackInSlot(i).m_41720_() instanceof BottledCloudItem)) continue;
                    return true;
                }
            }
            return false;
        }).orElse(false);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.bottled_cloud.double_jump").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

