/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class BrokenHeartItem
extends ModifiableBaubleItem {
    private static final UUID BROKEN_HEART_UUID = UUID.fromString("BBA1B2C3-D4E5-F6A7-B8C9-D0E1F2A3B4C5");
    private static final String DATA_KEY = "broken_heart_loss";
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public BrokenHeartItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void curioTick(SlotContext slotContext) {
                Player player;
                LivingEntity entity = slotContext.entity();
                if (entity instanceof Player && !(player = (Player)entity).m_9236_().m_5776_()) {
                    AttributeInstance maxHealthAttr = player.m_21051_(Attributes.f_22276_);
                    if (maxHealthAttr != null) {
                        float lastMax;
                        float currentMax = (float)maxHealthAttr.m_22135_();
                        if (Math.abs(currentMax - (lastMax = player.getPersistentData().m_128457_("LastMaxHealth"))) > 0.001f) {
                            BrokenHeartItem.triggerAttributeSync(player);
                            player.getPersistentData().m_128350_("LastMaxHealth", currentMax);
                        }
                        if (player.m_21223_() > currentMax) {
                            player.m_21153_(currentMax);
                        }
                    }
                    if (player.f_19797_ % 2 == 0) {
                        BrokenHeartItem.triggerAttributeSync(player);
                    }
                }
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    BrokenHeartItem.this.applyModifier(player, stack);
                    BrokenHeartItem.triggerAttributeSync(player);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    BrokenHeartItem.this.removeModifier(player, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (ModList.get().isLoaded("firstaid")) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.isCanceled() && !player.m_9236_().f_46443_ && BrokenHeartItem.isEquipped((LivingEntity)player)) {
                BrokenHeartItem.handleDamageProtection(player, event);
            }
        }
    }

    private static void handleDamageProtection(Player player, LivingHurtEvent event) {
        float damageAmount;
        float effectiveHealth = player.m_21223_() + player.m_6103_();
        if (effectiveHealth <= (damageAmount = event.getAmount())) {
            float overflowDamage = damageAmount - effectiveHealth;
            float adjustedDamage = overflowDamage <= 1.0f ? 1.0f : overflowDamage;
            AttributeInstance maxHealthAttr = player.m_21051_(Attributes.f_22276_);
            if (maxHealthAttr == null) {
                return;
            }
            float currentMax = (float)maxHealthAttr.m_22135_();
            if (currentMax > adjustedDamage) {
                event.setCanceled(true);
                player.m_7911_(0.0f);
                player.m_21153_(1.0f);
                CompoundTag data = player.getPersistentData();
                float totalLoss = data.m_128457_(DATA_KEY);
                data.m_128350_(DATA_KEY, totalLoss += adjustedDamage);
                BrokenHeartItem.updateHealthModifier(player, maxHealthAttr, totalLoss);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_9236_().m_6263_(null, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), SoundEvents.f_12008_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                BrokenHeartItem.triggerAttributeSync(player);
            }
        }
    }

    private static void updateHealthModifier(Player player, AttributeInstance maxHealthAttr, float totalLoss) {
        double newValue = -totalLoss;
        boolean needsUpdate = true;
        if (maxHealthAttr.m_22111_(BROKEN_HEART_UUID) != null) {
            double currentValue = maxHealthAttr.m_22111_(BROKEN_HEART_UUID).m_22218_();
            boolean bl = needsUpdate = Math.abs(currentValue - newValue) > 0.001;
        }
        if (needsUpdate) {
            maxHealthAttr.m_22120_(BROKEN_HEART_UUID);
            maxHealthAttr.m_22125_(new AttributeModifier(BROKEN_HEART_UUID, "broken_heart_penalty", newValue, AttributeModifier.Operation.ADDITION));
            player.getPersistentData().m_128350_("LastMaxHealth", (float)maxHealthAttr.m_22135_());
            BrokenHeartItem.triggerAttributeSync(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        if (ModList.get().isLoaded("firstaid")) {
            if (player.m_21051_(Attributes.f_22276_).m_22111_(BROKEN_HEART_UUID) != null) {
                player.m_21051_(Attributes.f_22276_).m_22120_(BROKEN_HEART_UUID);
            }
            return;
        }
        if (!player.m_9236_().f_46443_ && player.m_36317_() && BrokenHeartItem.isEquipped((LivingEntity)player)) {
            BrokenHeartItem.handleHealthRecovery(player);
            BrokenHeartItem.triggerAttributeSync(player);
        }
    }

    private static void handleHealthRecovery(Player player) {
        AttributeInstance maxHealthAttr;
        CompoundTag data = player.getPersistentData();
        float totalLoss = data.m_128457_(DATA_KEY);
        if (totalLoss > 0.0f && (maxHealthAttr = player.m_21051_(Attributes.f_22276_)) != null) {
            maxHealthAttr.m_22120_(BROKEN_HEART_UUID);
            double baseMaxHealth = maxHealthAttr.m_22135_();
            float recovery = Math.min(totalLoss, 4.0f);
            data.m_128350_(DATA_KEY, totalLoss -= recovery);
            if (totalLoss > 0.0f) {
                maxHealthAttr.m_22125_(new AttributeModifier(BROKEN_HEART_UUID, "broken_heart_penalty", (double)(-totalLoss), AttributeModifier.Operation.ADDITION));
            }
            float newMaxHealth = (float)maxHealthAttr.m_22135_();
            float currentHealth = player.m_21223_();
            if (currentHealth < newMaxHealth) {
                player.m_21153_(Math.min(currentHealth + recovery, newMaxHealth));
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_240418_((Component)Component.m_237113_((String)("Restored " + recovery + " max health")).m_130940_(ChatFormatting.GREEN), false);
                serverPlayer.m_240418_((Component)Component.m_237113_((String)("Current max health: " + String.format("%.1f", Float.valueOf(newMaxHealth)))).m_130940_(ChatFormatting.GRAY), false);
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.2f);
            }
            BrokenHeartItem.triggerAttributeSync(player);
        }
    }

    public static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(curios -> curios.findFirstCurio(stack -> stack.m_41720_() instanceof BrokenHeartItem)).isPresent();
    }

    private static void triggerAttributeSync(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            List<AttributeInstance> attributes = List.of(serverPlayer.m_21051_(Attributes.f_22276_));
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundUpdateAttributesPacket(serverPlayer.m_19879_(), attributes));
            AttributeModifier tempMod = new AttributeModifier(UUID.randomUUID(), "temp_sync", 0.0, AttributeModifier.Operation.ADDITION);
            AttributeInstance maxHealth = player.m_21051_(Attributes.f_22276_);
            if (maxHealth != null) {
                maxHealth.m_22118_(tempMod);
                maxHealth.m_22130_(tempMod);
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.broken_heart.effect").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.broken_heart.effect1").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.broken_heart.lore").m_130940_(ChatFormatting.GREEN));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

