/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class ButchersCleaverItem
extends ModifiableBaubleItem {
    private static final Random RANDOM = new Random();
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public ButchersCleaverItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    ButchersCleaverItem.this.applyModifier(player, stack);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    ButchersCleaverItem.this.removeModifier(player, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            LivingEntity victim;
            ItemStack headStack;
            boolean hasButchersCleaver;
            Player killer = (Player)entity;
            if (!killer.m_9236_().f_46443_ && (hasButchersCleaver = CuriosApi.getCuriosInventory((LivingEntity)killer).resolve().flatMap(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof ButchersCleaverItem)).isPresent()) && (double)RANDOM.nextFloat() < (Double)ModConfig.BUTCHERS_CLEAVER_DROP_CHANCE.get() && !(headStack = ButchersCleaverItem.findEntityHead(victim = event.getEntity())).m_41619_()) {
                victim.m_19983_(headStack);
            }
        }
    }

    private static ItemStack findEntityHead(LivingEntity entity) {
        String[] possiblePatterns;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack head = new ItemStack((ItemLike)Items.f_42680_);
            head.m_41784_().m_128359_("SkullOwner", player.m_7755_().getString());
            return head;
        }
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return ItemStack.f_41583_;
        }
        for (String pattern : possiblePatterns = new String[]{entityId.m_135827_() + ":head_" + entityId.m_135815_(), entityId.m_135827_() + ":" + entityId.m_135815_() + "_head", entityId.m_135827_() + ":" + entityId.m_135815_() + "_skull", entityId.m_135827_() + ":skull_" + entityId.m_135815_(), entityId.m_135827_() + ":" + entityId.m_135815_() + "_trophy", entityId.m_135827_() + ":trophy_" + entityId.m_135815_()}) {
            ResourceLocation itemId = new ResourceLocation(pattern);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (item == null || item.equals(Items.f_41852_)) continue;
            return new ItemStack((ItemLike)item);
        }
        String entityName = entityId.m_135815_();
        for (Item item : ForgeRegistries.ITEMS) {
            String itemPath;
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
            if (itemId == null || !(itemPath = itemId.m_135815_().toLowerCase()).contains(entityName) && !entityName.contains(itemPath) || !itemPath.contains("head") && !itemPath.contains("skull") && !itemPath.contains("trophy")) continue;
            return new ItemStack((ItemLike)item);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.butchers_cleaver.effect").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

