/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class CrossNecklaceItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public CrossNecklaceItem(Item.Properties properties) {
        super(properties);
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (ModConfig.crossNecklacePlayersOnly() && !(entity instanceof Player)) {
            return;
        }
        if (CrossNecklaceItem.isEquipped(entity)) {
            double boost = ModConfig.getCrossNecklaceBoost();
            if (boost <= 0.0) {
                return;
            }
            int currentTime = entity.f_19802_;
            int additionalTime = (int)((double)currentTime * boost);
            entity.f_19802_ = Math.min(currentTime + additionalTime, 60);
        }
    }

    private static boolean isEquipped(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(curios -> curios.findFirstCurio(stack -> stack.m_41720_() instanceof CrossNecklaceItem)).isPresent();
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    CrossNecklaceItem.this.applyModifier(player, stack);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    CrossNecklaceItem.this.removeModifier(player, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.cross_necklace.effect").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.cross_necklace.lore").m_130940_(ChatFormatting.GREEN));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

