/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;

public class CuriousKnucklesItem
extends ModifiableBaubleItem {
    private static final String KNUCKLES_UUID_KEY = "KnucklesUUID";
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public CuriousKnucklesItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    private UUID getOrCreateUniqueId(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128403_(KNUCKLES_UUID_KEY)) {
            UUID newUUID = UUID.randomUUID();
            nbt.m_128362_(KNUCKLES_UUID_KEY, newUUID);
        }
        return nbt.m_128342_(KNUCKLES_UUID_KEY);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.curious_knuckles.effect").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public boolean m_41475_() {
        return true;
    }

    @Mod.EventBusSubscriber(modid="bountifulbaubles", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class KnucklesStackHandler {
        private static final Map<UUID, AttributeModifier> ACTIVE_MODIFIERS = new ConcurrentHashMap<UUID, AttributeModifier>();
        private static final String MODIFIER_NAME = "bountifulbaubles:knuckles_stacked_damage";
        private static final double BASE_DAMAGE = 4.0;

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.START || event.player.m_9236_().m_5776_()) {
                return;
            }
            Player player = event.player;
            if (player.f_19797_ % 10 == 0) {
                KnucklesStackHandler.processStackedEffect(player);
            }
        }

        private static void processStackedEffect(Player player) {
            List<ItemStack> knuckles = CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.m_41720_() instanceof CuriousKnucklesItem)).orElse(Collections.emptyList()).stream().map(SlotResult::stack).toList();
            double totalBoost = 4.0 * (double)knuckles.size();
            KnucklesStackHandler.updateAttribute(player, totalBoost, knuckles);
        }

        private static void updateAttribute(Player player, double newBoost, List<ItemStack> knuckles) {
            UUID modifierId;
            AttributeModifier modifier;
            AttributeInstance attrib = player.m_21051_(Attributes.f_22281_);
            UUID playerId = player.m_20148_();
            if (ACTIVE_MODIFIERS.containsKey(playerId)) {
                AttributeModifier oldModifier = ACTIVE_MODIFIERS.get(playerId);
                if (attrib.m_22109_(oldModifier)) {
                    attrib.m_22120_(oldModifier.m_22209_());
                }
                ACTIVE_MODIFIERS.remove(playerId);
            }
            knuckles.forEach(stack -> {
                UUID itemUUID = ((CuriousKnucklesItem)stack.m_41720_()).getOrCreateUniqueId((ItemStack)stack);
                AttributeModifier existing = attrib.m_22111_(itemUUID);
                if (existing != null) {
                    attrib.m_22120_(itemUUID);
                }
            });
            if (newBoost > 0.0 && !attrib.m_22109_(modifier = new AttributeModifier(modifierId = knuckles.stream().map(stack -> ((CuriousKnucklesItem)stack.m_41720_()).getOrCreateUniqueId((ItemStack)stack)).reduce((u1, u2) -> UUID.nameUUIDFromBytes((u1.toString() + u2.toString()).getBytes())).orElse(UUID.randomUUID()), MODIFIER_NAME, newBoost, AttributeModifier.Operation.ADDITION))) {
                attrib.m_22125_(modifier);
                ACTIVE_MODIFIERS.put(playerId, modifier);
            }
        }

        @SubscribeEvent
        public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
            KnucklesStackHandler.cleanupPlayer(event.getEntity());
        }

        @SubscribeEvent
        public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
            KnucklesStackHandler.cleanupPlayer(event.getEntity());
        }

        private static void cleanupPlayer(Player player) {
            UUID playerId = player.m_20148_();
            if (ACTIVE_MODIFIERS.containsKey(playerId)) {
                AttributeModifier modifier;
                AttributeInstance attrib = player.m_21051_(Attributes.f_22281_);
                if (attrib.m_22109_(modifier = ACTIVE_MODIFIERS.get(playerId))) {
                    attrib.m_22130_(modifier);
                }
                ACTIVE_MODIFIERS.remove(playerId);
            }
        }
    }
}

