/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class CuriousRingItem
extends ModifiableBaubleItem {
    private static final String SPEED_UUID_KEY = "RingSpeedUUID";
    private static final String ATTACK_SPEED_UUID_KEY = "RingAttackSpeedUUID";
    private static final String ARMOR_UUID_KEY = "RingArmorUUID";
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public CuriousRingItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity entity = slotContext.entity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    CuriousRingItem.this.applyModifier(player, stack);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity entity = slotContext.entity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    CuriousRingItem.this.removeModifier(player, stack);
                    player.m_21195_(MobEffects.f_19598_);
                }
            }

            public void curioTick(SlotContext slotContext) {
                LivingEntity entity = slotContext.entity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, Integer.MAX_VALUE, 0, true, true, false){

                        public boolean isCurativeItem(ItemStack stack) {
                            return false;
                        }
                    });
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }
        });
    }

    private void initializeUUIDs(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128403_(SPEED_UUID_KEY)) {
            tag.m_128362_(SPEED_UUID_KEY, UUID.randomUUID());
        }
        if (!tag.m_128403_(ATTACK_SPEED_UUID_KEY)) {
            tag.m_128362_(ATTACK_SPEED_UUID_KEY, UUID.randomUUID());
        }
        if (!tag.m_128403_(ARMOR_UUID_KEY)) {
            tag.m_128362_(ARMOR_UUID_KEY, UUID.randomUUID());
        }
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.curious_ring.effect").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.curious_ring.effect1").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.curious_ring.effect2").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }

    @Mod.EventBusSubscriber(modid="bountifulbaubles", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class RingEffectHandler {
        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                return;
            }
            Player player = event.player;
            if (!player.m_9236_().m_5776_() && player.f_19797_ % 10 == 0) {
                RingEffectHandler.updateRingAttributes(player);
            }
        }

        private static void updateRingAttributes(Player player) {
            int ringCount = CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.m_41720_() instanceof CuriousRingItem).size()).orElse(0);
            double speedBoost = 0.1 * (double)ringCount;
            double atkSpeedBoost = 0.1 * (double)ringCount;
            double armorBoost = 2.0 * (double)ringCount;
            RingEffectHandler.applyAttributeModifiers(player, Attributes.f_22279_, "bountifulbaubles:ring_movement_speed", speedBoost, AttributeModifier.Operation.MULTIPLY_TOTAL);
            RingEffectHandler.applyAttributeModifiers(player, Attributes.f_22283_, "bountifulbaubles:ring_attack_speed", atkSpeedBoost, AttributeModifier.Operation.MULTIPLY_TOTAL);
            RingEffectHandler.applyAttributeModifiers(player, Attributes.f_22284_, "bountifulbaubles:ring_armor", armorBoost, AttributeModifier.Operation.ADDITION);
        }

        private static void applyAttributeModifiers(Player player, Attribute attribute, String modifierName, double amount, AttributeModifier.Operation op) {
            AttributeInstance attrib = player.m_21051_(attribute);
            UUID modifierId = UUID.nameUUIDFromBytes((modifierName + player.m_20148_()).getBytes());
            attrib.m_22120_(modifierId);
            if (amount > 0.0) {
                AttributeModifier modifier = new AttributeModifier(modifierId, modifierName, amount, op);
                attrib.m_22125_(modifier);
            }
        }
    }
}

