/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DarkEggItem
extends ModifiableBaubleItem {
    private static final String TAG_IS_INITIALIZED = "IsInitialized";
    private static final String COOLDOWN_KEY = "DarkEggCooldown";
    public static final String DARK_EGG_CONTROLLED_TAG = "DarkEggControlled";
    public static final String FRIENDLY_VEX_TAG = "FriendlyVex";
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public DarkEggItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            long cooldownEnd;
            Player player = (Player)livingEntity;
            CompoundTag tag = stack.m_41784_();
            long currentTime = player.m_9236_().m_46467_();
            if (tag.m_128441_(COOLDOWN_KEY) && currentTime >= (cooldownEnd = tag.m_128454_(COOLDOWN_KEY))) {
                tag.m_128473_(COOLDOWN_KEY);
            }
            if (!player.m_9236_().f_46443_) {
                AABB searchBox = player.m_20191_().m_82400_(32.0);
                player.m_9236_().m_45976_(Vex.class, searchBox).forEach(vex -> {
                    if (vex.getPersistentData().m_128471_(FRIENDLY_VEX_TAG) && (vex.m_5448_() == null || vex.m_5448_().m_21224_())) {
                        DarkEggItem.followPlayer(vex, player);
                    }
                });
            }
        }
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        if (!stack.m_41784_().m_128471_(TAG_IS_INITIALIZED)) {
            stack.m_41784_().m_128379_(TAG_IS_INITIALIZED, true);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
    }

    private static void followPlayer(Vex vex, Player player) {
        double followDistance = vex.m_20280_((Entity)player);
        AABB searchBox = vex.m_20191_().m_82400_(16.0);
        List nearbyEntities = vex.m_9236_().m_6443_(LivingEntity.class, searchBox, entity -> entity != player && entity != vex && !(entity instanceof Player) && !entity.getPersistentData().m_128471_(FRIENDLY_VEX_TAG) && entity.m_6084_() && (entity.m_21188_() == player || entity instanceof Vex && !((Vex)entity).getPersistentData().m_128471_(FRIENDLY_VEX_TAG)));
        if (!nearbyEntities.isEmpty()) {
            LivingEntity nearestTarget = (LivingEntity)nearbyEntities.get(0);
            double nearestDistance = vex.m_20280_((Entity)nearestTarget);
            for (LivingEntity entity2 : nearbyEntities) {
                double distance = vex.m_20280_((Entity)entity2);
                if (!(distance < nearestDistance)) continue;
                nearestDistance = distance;
                nearestTarget = entity2;
            }
            vex.m_6710_(nearestTarget);
            if (nearestDistance > 64.0) {
                double targetX = nearestTarget.m_20185_() + (vex.m_217043_().m_188500_() - 0.5) * 4.0;
                double targetY = nearestTarget.m_20186_() + 1.5;
                double targetZ = nearestTarget.m_20189_() + (vex.m_217043_().m_188500_() - 0.5) * 4.0;
                vex.m_21566_().m_6849_(targetX, targetY, targetZ, 1.2);
            }
            return;
        }
        if (followDistance > 256.0) {
            double angle = vex.m_217043_().m_188500_() * Math.PI * 2.0;
            double radius = 8.0 + vex.m_217043_().m_188500_() * 4.0;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            double offsetY = 2.0 + vex.m_217043_().m_188500_() * 2.0;
            vex.m_6027_(player.m_20185_() + offsetX, player.m_20186_() + offsetY, player.m_20189_() + offsetZ);
        } else if (followDistance > 64.0) {
            double angle = Math.atan2(player.m_20189_() - vex.m_20189_(), player.m_20185_() - vex.m_20185_());
            double targetRadius = 6.0;
            double targetX = player.m_20185_() + Math.cos(angle) * targetRadius;
            double targetZ = player.m_20189_() + Math.sin(angle) * targetRadius;
            double targetY = player.m_20186_() + 2.0 + vex.m_217043_().m_188500_() * 2.0;
            vex.m_21566_().m_6849_(targetX, targetY, targetZ, 0.8);
        }
    }

    private static void setVexFriendly(Vex vex, Player player) {
        vex.m_21530_();
        vex.m_6593_((Component)Component.m_237113_((String)(player.m_7755_().getString() + "'s Vex")));
        vex.m_20340_(true);
        vex.m_21051_(Attributes.f_22279_).m_22100_(0.5);
        vex.m_21051_(Attributes.f_22277_).m_22100_(48.0);
        vex.m_21051_(Attributes.f_22281_).m_22100_(6.0);
        CompoundTag data = vex.getPersistentData();
        data.m_128379_(DARK_EGG_CONTROLLED_TAG, true);
        data.m_128379_(FRIENDLY_VEX_TAG, true);
        data.m_128359_("OwnerUUID", player.m_20149_());
        vex.m_33987_(ModConfig.getDarkEggVexLifetime());
        vex.m_20049_("dark_egg_controlled");
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof DarkEggItem).ifPresent(result -> {
                Level patt8320$temp;
                ItemStack stack = result.stack();
                CompoundTag tag = stack.m_41784_();
                if (!tag.m_128441_(COOLDOWN_KEY) && (patt8320$temp = player.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt8320$temp;
                    tag.m_128356_(COOLDOWN_KEY, player.m_9236_().m_46467_() + (long)ModConfig.getDarkEggCooldown());
                    serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    attacker = null;
                    if (event.getSource().m_7639_() instanceof LivingEntity && !(event.getSource().m_7639_() instanceof Player)) {
                        attacker = (LivingEntity)event.getSource().m_7639_();
                    }
                    LivingEntity finalAttacker = attacker;
                    for (int i = 0; i < ModConfig.getDarkEggVexCount(); ++i) {
                        double angle = Math.PI * 2 * (double)i / (double)ModConfig.getDarkEggVexCount();
                        double radius = 8.0 + player.m_217043_().m_188500_() * 4.0;
                        double offsetX = Math.cos(angle) * radius;
                        double offsetZ = Math.sin(angle) * radius;
                        double offsetY = 2.0 + player.m_217043_().m_188500_() * 2.0;
                        BlockPos spawnPos = new BlockPos((int)(player.m_20185_() + offsetX), (int)(player.m_20186_() + offsetY), (int)(player.m_20189_() + offsetZ));
                        Vex vex2 = (Vex)EntityType.f_20491_.m_20592_(serverLevel, null, player, spawnPos, MobSpawnType.MOB_SUMMONED, true, false);
                        if (vex2 == null) continue;
                        DarkEggItem.setVexFriendly(vex2, player);
                        if (finalAttacker == null || finalAttacker == player) continue;
                        vex2.m_6710_(finalAttacker);
                    }
                } else {
                    Entity patt11209$temp = event.getSource().m_7639_();
                    if (patt11209$temp instanceof LivingEntity && (attacker = (LivingEntity)patt11209$temp) != player && !(attacker instanceof Player)) {
                        AABB searchBox = player.m_20191_().m_82400_(32.0);
                        player.m_9236_().m_45976_(Vex.class, searchBox).forEach(vex -> {
                            if (vex.getPersistentData().m_128471_(FRIENDLY_VEX_TAG) && vex.getPersistentData().m_128461_("OwnerUUID").equals(player.m_20149_())) {
                                vex.m_6710_(attacker);
                            }
                        });
                    }
                }
            }));
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LivingEntity target = event.getEntity();
            if (target != null && !(target instanceof Player)) {
                AABB searchBox = player.m_20191_().m_82400_(32.0);
                player.m_9236_().m_45976_(Vex.class, searchBox).forEach(vex -> {
                    if (vex.getPersistentData().m_128471_(FRIENDLY_VEX_TAG) && vex.getPersistentData().m_128461_("OwnerUUID").equals(player.m_20149_())) {
                        vex.m_6710_(target);
                    }
                });
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.bountifulbaubles.darkegg.effects", (Object[])new Object[]{ModConfig.getDarkEggVexCount(), ModConfig.getDarkEggCooldown() / 20}).m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.bountifulbaubles.darkegg.description", (Object[])new Object[]{ModConfig.getDarkEggVexLifetime() / 20}).m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

