/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class DragonBreathItem
extends ModifiableBaubleItem {
    public DragonBreathItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return ModifiableBaubleItem.Modifier.values();
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    DragonBreathItem.this.applyModifier(player, stack);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    DragonBreathItem.this.removeModifier(player, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockDrop(BlockEvent.BreakEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Player player = event.getPlayer();
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        BlockPos pos = event.getPos();
        ItemStack tool = player.m_21205_();
        if (!event.getState().canHarvestBlock((BlockGetter)serverLevel, pos, player)) {
            return;
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0) {
            return;
        }
        boolean hasBreath = CuriosApi.getCuriosInventory((LivingEntity)player).resolve().flatMap(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof DragonBreathItem)).isPresent();
        if (!hasBreath) {
            return;
        }
        List drops = Block.m_49874_((BlockState)event.getState(), (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
        if (drops.isEmpty()) {
            return;
        }
        for (ItemStack drop : drops) {
            Optional<SmeltingRecipe> recipe = serverLevel.m_7465_().m_44013_(RecipeType.f_44108_).stream().filter(r -> ((Ingredient)r.m_7527_().get(0)).test(drop)).findFirst();
            if (!recipe.isPresent()) continue;
            ItemStack smeltedItem = recipe.get().m_8043_(serverLevel.m_9598_()).m_41777_();
            smeltedItem.m_41764_(drop.m_41613_());
            Block.m_49840_((Level)serverLevel, (BlockPos)pos, (ItemStack)smeltedItem);
            if (!tool.m_41619_() && tool.m_41763_()) {
                int damage = 1;
                int unbreakingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)tool);
                if (unbreakingLevel > 0) {
                    float chance = 1.0f / (float)(unbreakingLevel + 1);
                    if (player.m_217043_().m_188501_() < chance) {
                        tool.m_41622_(damage, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                    }
                } else {
                    tool.m_41622_(damage, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                }
            }
            event.setCanceled(true);
            serverLevel.m_7471_(pos, false);
            serverLevel.m_46796_(2001, pos, Block.m_49956_((BlockState)event.getState()));
            return;
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.dragon_breath.effect").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

