/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.network.handler.NetworkHandler;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class InfiniteTotemOfUndyingItem
extends ModifiableBaubleItem {
    public static final String PUBLIC_COOLDOWN_TAG = "TotemPublicCooldown";
    public static final int DEFAULT_COOLDOWN = 6000;
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public InfiniteTotemOfUndyingItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean isReady(Player player) {
        CompoundTag playerData = player.getPersistentData();
        return !playerData.m_128441_(PUBLIC_COOLDOWN_TAG) || playerData.m_128451_(PUBLIC_COOLDOWN_TAG) <= 0;
    }

    public static void startCooldown(Player player) {
        int cooldown = Math.max((Integer)ModConfig.COOLDOWN_TICKS.get(), 1);
        player.getPersistentData().m_128405_(PUBLIC_COOLDOWN_TAG, cooldown);
    }

    public static void adjustExistingCooldown(Player player) {
        int maxCooldown;
        int current;
        CompoundTag data = player.getPersistentData();
        if (data.m_128441_(PUBLIC_COOLDOWN_TAG) && (current = data.m_128451_(PUBLIC_COOLDOWN_TAG)) > (maxCooldown = Math.max((Integer)ModConfig.COOLDOWN_TICKS.get(), 1))) {
            data.m_128405_(PUBLIC_COOLDOWN_TAG, maxCooldown);
        }
    }

    public static void triggerTotemEffects(Player player, ItemStack stack) {
        player.m_21153_(1.0f);
        player.m_21219_();
        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
        Level world = player.m_9236_();
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_5496_(SoundEvents.f_12513_, 1.0f, 1.0f);
        if (!world.f_46443_) {
            Vec3 pos = player.m_20182_();
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new NetworkHandler.TotemParticlesPacket(pos.f_82479_, pos.f_82480_, pos.f_82481_));
        }
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_142522_(ItemStack stack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player != null && player.getPersistentData().m_128441_(PUBLIC_COOLDOWN_TAG);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int m_142158_(ItemStack stack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.getPersistentData().m_128441_(PUBLIC_COOLDOWN_TAG)) {
            int remaining = player.getPersistentData().m_128451_(PUBLIC_COOLDOWN_TAG);
            return (int)(13.0f - (float)remaining * 13.0f / (float)((Integer)ModConfig.COOLDOWN_TICKS.get()).intValue());
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int m_142159_(ItemStack stack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.getPersistentData().m_128441_(PUBLIC_COOLDOWN_TAG)) {
            int remaining = player.getPersistentData().m_128451_(PUBLIC_COOLDOWN_TAG);
            float progress = (float)((Integer)ModConfig.COOLDOWN_TICKS.get() - remaining) / (float)((Integer)ModConfig.COOLDOWN_TICKS.get()).intValue();
            return Mth.m_14169_((float)(progress * 0.33f), (float)1.0f, (float)1.0f);
        }
        return super.m_142159_(stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.infinite_totem_undying.effect").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.infinite_totem_undying.description").m_130940_(ChatFormatting.GREEN));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

