/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class LuckCoinItem
extends ModifiableBaubleItem {
    private static final Random RANDOM = new Random();

    public LuckCoinItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return ModifiableBaubleItem.Modifier.values();
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    LuckCoinItem.this.applyModifier(player, stack);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    LuckCoinItem.this.removeModifier(player, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean hasLuckCoin = CuriosApi.getCuriosInventory((LivingEntity)player).resolve().flatMap(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof LuckCoinItem)).isPresent();
        if (!hasLuckCoin) {
            return;
        }
        List<Double> bonuses = ModConfig.getLuckCoinDamageBonuses();
        List<Double> probabilities = ModConfig.getLuckCoinProbabilities();
        if (bonuses.size() != probabilities.size()) {
            return;
        }
        double roll = RANDOM.nextDouble();
        double cumulativeProbability = 0.0;
        for (int i = 0; i < probabilities.size(); ++i) {
            if (!(roll < (cumulativeProbability += probabilities.get(i).doubleValue()))) continue;
            float bonus = (float)(1.0 + bonuses.get(i));
            event.setAmount(event.getAmount() * bonus);
            break;
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        List<Double> bonuses = ModConfig.getLuckCoinDamageBonuses();
        List<Double> probabilities = ModConfig.getLuckCoinProbabilities();
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.luckcoin.title").m_130940_(ChatFormatting.BLUE));
        for (int i = 0; i < bonuses.size() && i < probabilities.size(); ++i) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.bountifulbaubles.luckcoin.bonus_line", (Object[])new Object[]{probabilities.get(i) * 100.0, bonuses.get(i) * 100.0}).m_130940_(ChatFormatting.BLUE));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

