/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.network.handler.NetworkHandler;
import com.jinqinxixi.bountifulbaubles.network.packet.MarkTargetPacket;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class MindsEyeItem
extends ModifiableBaubleItem {
    private static final Map<UUID, Map.Entry<Integer, Long>> MARKED_TARGETS = new HashMap<UUID, Map.Entry<Integer, Long>>();
    private static final Map<UUID, Boolean> SHOULD_REMARK = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Long> SCAN_COOLDOWNS = new HashMap<UUID, Long>();
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public static Map<UUID, Map.Entry<Integer, Long>> getMarkedTargets() {
        return MARKED_TARGETS;
    }

    public MindsEyeItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    MindsEyeItem.this.applyModifier(player, stack);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    MindsEyeItem.this.removeModifier(player, stack);
                    MindsEyeItem.clearMarkedTarget(player);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        UUID playerUUID = player.m_20148_();
        boolean hasGoggles = CuriosApi.getCuriosInventory((LivingEntity)player).resolve().flatMap(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof MindsEyeItem)).isPresent();
        if (!hasGoggles) {
            MindsEyeItem.clearMarkedTarget(player);
            SHOULD_REMARK.remove(playerUUID);
            return;
        }
        long currentTime = player.m_9236_().m_46467_();
        if (SHOULD_REMARK.getOrDefault(playerUUID, false).booleanValue()) {
            MindsEyeItem.scanAndMarkTarget(player);
            SHOULD_REMARK.put(playerUUID, false);
            return;
        }
        long nextScanTime = SCAN_COOLDOWNS.getOrDefault(playerUUID, 0L);
        if (currentTime >= nextScanTime) {
            MindsEyeItem.scanAndMarkTarget(player);
            SCAN_COOLDOWNS.put(playerUUID, currentTime + (long)ModConfig.getTacticalScanInterval());
        }
        MindsEyeItem.updateMarkedTargets(player);
    }

    private static void scanAndMarkTarget(Player player) {
        List nearbyMobs = player.m_9236_().m_6443_(Mob.class, new AABB(player.m_20182_().m_82492_(ModConfig.getTacticalScanRadius(), ModConfig.getTacticalDownRange(), ModConfig.getTacticalScanRadius()), player.m_20182_().m_82520_(ModConfig.getTacticalScanRadius(), ModConfig.getTacticalUpRange(), ModConfig.getTacticalScanRadius())), mob -> {
            double dz;
            if (!mob.m_6084_() || mob.m_20145_()) {
                return false;
            }
            boolean isHostile = mob instanceof Enemy;
            if (!isHostile) {
                return false;
            }
            if (MARKED_TARGETS.containsKey(player.m_20148_()) && MARKED_TARGETS.get(player.m_20148_()).getKey().intValue() == mob.m_19879_()) {
                return false;
            }
            double dx = mob.m_20185_() - player.m_20185_();
            double horizontalDistSqr = dx * dx + (dz = mob.m_20189_() - player.m_20189_()) * dz;
            if (horizontalDistSqr > ModConfig.getTacticalScanRadius() * ModConfig.getTacticalScanRadius()) {
                return false;
            }
            return player.m_9236_().m_45547_(new ClipContext(player.m_146892_(), mob.m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).m_6662_() == HitResult.Type.MISS;
        });
        if (!nearbyMobs.isEmpty()) {
            MindsEyeItem.clearMarkedTarget(player);
            Mob target = (Mob)nearbyMobs.get(player.m_217043_().m_188503_(nearbyMobs.size()));
            long endTime = player.m_9236_().m_46467_() + (long)ModConfig.getTacticalMarkDuration();
            MARKED_TARGETS.put(player.m_20148_(), new AbstractMap.SimpleEntry<Integer, Long>(target.m_19879_(), endTime));
            MindsEyeItem.sendMarkPacket(player, target.m_19879_(), endTime);
            player.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 1.0f, 2.0f);
        } else if (SHOULD_REMARK.getOrDefault(player.m_20148_(), false).booleanValue()) {
            SHOULD_REMARK.put(player.m_20148_(), false);
            SCAN_COOLDOWNS.put(player.m_20148_(), player.m_9236_().m_46467_() + (long)ModConfig.getTacticalScanInterval());
        }
    }

    private static void updateMarkedTargets(Player player) {
        Map.Entry<Integer, Long> targetInfo = MARKED_TARGETS.get(player.m_20148_());
        if (targetInfo != null && player.m_9236_().m_46467_() > targetInfo.getValue()) {
            MindsEyeItem.clearMarkedTarget(player);
        }
    }

    private static void clearMarkedTarget(Player player) {
        UUID playerUUID = player.m_20148_();
        Map.Entry<Integer, Long> targetInfo = MARKED_TARGETS.get(playerUUID);
        if (targetInfo != null) {
            MARKED_TARGETS.remove(playerUUID);
            SHOULD_REMARK.remove(playerUUID);
            if (!player.m_9236_().f_46443_) {
                NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new MarkTargetPacket(playerUUID, targetInfo.getKey(), 0L, true));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Player player;
        Map.Entry<Integer, Long> targetInfo;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && (targetInfo = MARKED_TARGETS.get((player = (Player)entity).m_20148_())) != null && event.getEntity().m_19879_() == targetInfo.getKey().intValue()) {
            event.setAmount(event.getAmount() * (float)ModConfig.getTacticalDamageMultiplier());
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        UUID playerUUID;
        Map.Entry<Integer, Long> targetInfo;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && (targetInfo = MARKED_TARGETS.get(playerUUID = (player = (Player)entity).m_20148_())) != null && event.getEntity().m_19879_() == targetInfo.getKey().intValue()) {
            SHOULD_REMARK.put(playerUUID, true);
            SCAN_COOLDOWNS.remove(playerUUID);
        }
    }

    private static void sendMarkPacket(Player player, int entityId, long endTime) {
        if (!player.m_9236_().f_46443_) {
            NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new MarkTargetPacket(player.m_20148_(), entityId, endTime, false));
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.bountifulbaubles.minds_eye.effects", (Object[])new Object[]{Float.valueOf((float)((Integer)ModConfig.TACTICAL_SCAN_INTERVAL.get()).intValue() / 20.0f)}).m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.bountifulbaubles.minds_eye.effects1", (Object[])new Object[]{((Double)ModConfig.TACTICAL_DAMAGE_MULTIPLIER.get() - 1.0) * 100.0}).m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.minds_eye.effects2").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

