/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber
public class ObsidianSkullItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public ObsidianSkullItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag unused) {
        return super.initCapabilities(stack, unused);
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        if (ObsidianSkullItem.isFireDamage(source) && !ObsidianSkullItem.isLavaDamage(source)) {
            ObsidianSkullItem.checkAndApplyProtection(entity, event);
        }
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        if (ObsidianSkullItem.isFireDamage(source) && ObsidianSkullItem.hasSkull(entity)) {
            entity.m_20095_();
        }
    }

    private static void checkAndApplyProtection(LivingEntity entity, LivingHurtEvent event) {
        if (ObsidianSkullItem.hasSkull(entity)) {
            event.setAmount(event.getAmount() * 0.5f);
        }
    }

    private static boolean hasSkull(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        return CuriosApi.getCuriosInventory((LivingEntity)player).resolve().map(inv -> inv.findFirstCurio(stack -> stack.m_41720_() instanceof ObsidianSkullItem).isPresent()).orElse(false);
    }

    private static boolean isFireDamage(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268684_) || source.m_276093_(DamageTypes.f_268556_);
    }

    private static boolean isLavaDamage(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268546_) || source.m_276093_(DamageTypes.f_268434_);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.obsidian_skull.effect").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.obsidian_skull.description").m_130940_(ChatFormatting.GREEN));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

