/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class RingOverclockingItem
extends ModifiableBaubleItem {
    private static final double SPEED_BOOST = 0.07;
    private static final String SPEED_UUID_KEY = "SpeedUUID";
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public RingOverclockingItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity entity = slotContext.entity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    RingOverclockingItem.initializeSpeedUUID(stack);
                    RingOverclockingItem.this.applyModifier(player, stack);
                    RingOverclockingItem.applySpeedModifier(player, stack);
                    RingOverclockingItem.clearSlownessEffect(player);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity entity = slotContext.entity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    RingOverclockingItem.this.removeModifier(player, stack);
                    RingOverclockingItem.removeSpeedModifier(player, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    private static void initializeSpeedUUID(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128403_(SPEED_UUID_KEY)) {
            tag.m_128362_(SPEED_UUID_KEY, UUID.randomUUID());
        }
    }

    private static void applySpeedModifier(Player player, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128403_(SPEED_UUID_KEY)) {
            UUID speedUUID = tag.m_128342_(SPEED_UUID_KEY);
            AttributeModifier existing = player.m_21051_(Attributes.f_22279_).m_22111_(speedUUID);
            if (existing == null || existing.m_22218_() != 0.07) {
                player.m_21051_(Attributes.f_22279_).m_22120_(speedUUID);
                AttributeModifier modifier = new AttributeModifier(speedUUID, "RingOverclockingSpeedBoost", 0.07, AttributeModifier.Operation.MULTIPLY_TOTAL);
                player.m_21051_(Attributes.f_22279_).m_22118_(modifier);
            }
        }
    }

    private static void removeSpeedModifier(Player player, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128403_(SPEED_UUID_KEY)) {
            UUID speedUUID = tag.m_128342_(SPEED_UUID_KEY);
            player.m_21051_(Attributes.f_22279_).m_22120_(speedUUID);
        }
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEffectApplicable(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MobEffectInstance effect = event.getEffectInstance();
            if (effect != null && effect.m_19544_() == MobEffects.f_19597_) {
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curios -> {
                    if (curios.findFirstCurio(stack -> stack.m_41720_() instanceof RingOverclockingItem).isPresent()) {
                        event.setResult(Event.Result.DENY);
                        RingOverclockingItem.clearSlownessEffect(player);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curios -> {
                if (curios.findFirstCurio(stack -> stack.m_41720_() instanceof RingOverclockingItem).isPresent()) {
                    RingOverclockingItem.clearSlownessEffect(player);
                }
            });
        }
    }

    private static void clearSlownessEffect(Player player) {
        player.m_21195_(MobEffects.f_19597_);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.ring_overclocking.effect").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.ring_overclocking.description").m_130940_(ChatFormatting.GREEN));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

