/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class RockCandyItem
extends ModifiableBaubleItem {
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("9e8f0f0f-0f0f-0f0f-0f0f-0f0f0f0f0f0f");
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public RockCandyItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    private boolean hasSpeedModifier(Player player) {
        return player.m_21051_(Attributes.f_22279_).m_22111_(SPEED_MODIFIER_UUID) != null;
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    RockCandyItem.this.applyModifier(player, stack);
                    if (!RockCandyItem.this.hasSpeedModifier(player)) {
                        player.m_21051_(Attributes.f_22279_).m_22118_(new AttributeModifier(SPEED_MODIFIER_UUID, "Rock Candy Speed Boost", ((Double)ModConfig.ROCK_CANDY_SPEED_MULTIPLIER.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
                    }
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    RockCandyItem.this.removeModifier(player, stack);
                    boolean hasOtherRockCandy = CuriosApi.getCuriosInventory((LivingEntity)player).resolve().map(handler -> handler.findCurios(item -> item.m_41720_() instanceof RockCandyItem).size() > 0).orElse(false);
                    if (!hasOtherRockCandy) {
                        player.m_21051_(Attributes.f_22279_).m_22120_(SPEED_MODIFIER_UUID);
                    }
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        boolean hasRockCandy = CuriosApi.getCuriosInventory((LivingEntity)player).resolve().flatMap(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof RockCandyItem)).isPresent();
        if (hasRockCandy) {
            event.setAmount(event.getAmount() * ((Double)ModConfig.ROCK_CANDY_DAMAGE_MULTIPLIER.get()).floatValue());
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.bountifulbaubles.rock_candy.speed_boost", (Object[])new Object[]{String.format("%.0f", (Double)ModConfig.ROCK_CANDY_SPEED_MULTIPLIER.get() * 100.0)}).m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.bountifulbaubles.rock_candy.damage_warning", (Object[])new Object[]{String.format("%.1f", ModConfig.ROCK_CANDY_DAMAGE_MULTIPLIER.get())}).m_130940_(ChatFormatting.RED));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.rock_candy.no_stack").m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

