/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class ThaSpiderItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public ThaSpiderItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    ThaSpiderItem.this.applyModifier(player, stack);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    ThaSpiderItem.this.removeModifier(player, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        boolean hasSpiderRing = CuriosApi.getCuriosInventory((LivingEntity)player).resolve().flatMap(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof ThaSpiderItem)).isPresent();
        if (hasSpiderRing) {
            ThaSpiderItem.handleWallClimb(player);
        }
    }

    private static void handleWallClimb(Player player) {
        if (!player.m_20096_() && !player.m_20069_() && !player.m_20077_() && player.f_20902_ > 0.0f) {
            if (ThaSpiderItem.isPlayerTouchingWall(player)) {
                Vec3 motion = player.m_20184_();
                if (player.m_6144_()) {
                    player.m_20334_(motion.f_82479_, 0.0, motion.f_82481_);
                } else {
                    double upwardSpeed = 0.11;
                    player.m_20334_(motion.f_82479_, upwardSpeed, motion.f_82481_);
                }
                player.m_183634_();
                double drag = 0.7;
                player.m_20256_(player.m_20184_().m_82542_(drag, 1.0, drag));
            }
        } else if (ThaSpiderItem.isPlayerTouchingWall(player) && player.m_6144_()) {
            player.m_20256_(player.m_20184_().m_82542_(0.7, 0.0, 0.7));
            player.m_183634_();
        }
    }

    private static boolean isPlayerTouchingWall(Player player) {
        AABB boundingBox = player.m_20191_();
        AABB checkBox = boundingBox.m_82377_(0.15, 0.0, 0.15);
        Level level = player.m_9236_();
        int minX = (int)Math.floor(checkBox.f_82288_);
        int maxX = (int)Math.ceil(checkBox.f_82291_);
        int minY = (int)Math.floor(boundingBox.f_82289_);
        int maxY = (int)Math.ceil(boundingBox.f_82292_);
        int minZ = (int)Math.floor(checkBox.f_82290_);
        int maxZ = (int)Math.ceil(checkBox.f_82293_);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        double[] checkPoints = new double[]{player.m_20185_() - 0.35, player.m_20185_() + 0.35, player.m_20189_() - 0.35, player.m_20189_() + 0.35};
        for (int y = minY; y <= maxY; ++y) {
            pos.m_122169_(checkPoints[0], (double)y, player.m_20189_());
            if (ThaSpiderItem.isValidWall(level, (BlockPos)pos)) {
                return true;
            }
            pos.m_122169_(checkPoints[1], (double)y, player.m_20189_());
            if (ThaSpiderItem.isValidWall(level, (BlockPos)pos)) {
                return true;
            }
            pos.m_122169_(player.m_20185_(), (double)y, checkPoints[2]);
            if (ThaSpiderItem.isValidWall(level, (BlockPos)pos)) {
                return true;
            }
            pos.m_122169_(player.m_20185_(), (double)y, checkPoints[3]);
            if (!ThaSpiderItem.isValidWall(level, (BlockPos)pos)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidWall(Level level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        if (!blockState.m_60795_() && blockState.m_280296_() && !(blockState.m_60734_() instanceof LadderBlock) && !(blockState.m_60734_() instanceof VineBlock)) {
            VoxelShape shape = blockState.m_60812_((BlockGetter)level, pos);
            return !shape.m_83281_();
        }
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.tha_spider.effect").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

