/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber
public class WarmVoidItem
extends ModifiableBaubleItem {
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    public WarmVoidItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    WarmVoidItem.this.applyModifier(player, stack);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    WarmVoidItem.this.removeModifier(player, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            boolean hasWarmVoidItem;
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_ && event.getSource().m_269415_().f_268677_().equals("outOfWorld") && (hasWarmVoidItem = CuriosApi.getCuriosInventory((LivingEntity)player).resolve().flatMap(handler -> handler.findFirstCurio(item -> item.m_41720_() instanceof WarmVoidItem)).isPresent())) {
                event.setCanceled(true);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ServerLevel serverLevel = serverPlayer.m_284548_();
                    BlockPos spawnPos = serverPlayer.m_8961_();
                    float spawnAngle = serverPlayer.m_8962_();
                    if (spawnPos == null) {
                        spawnPos = serverLevel.m_220360_();
                        spawnAngle = 0.0f;
                    }
                    if (spawnPos != null) {
                        serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        player.m_6021_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 0.1, (double)spawnPos.m_123343_() + 0.5);
                        player.m_20334_(0.0, 0.0, 0.0);
                        player.f_19789_ = 0.0f;
                        serverLevel.m_6263_(null, (double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        player.m_213846_((Component)Component.m_237115_((String)"message.bountifulbaubles.warm_void.teleport").m_130940_(ChatFormatting.LIGHT_PURPLE));
                    }
                }
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.warm_void.effects").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

