/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.wormhole.PacketHandler;
import com.jinqinxixi.bountifulbaubles.system.wormhole.TeleportRequestManager;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class WormholeMirrorItem
extends Item {
    private static final int COOLDOWN_TICKS = 10;
    private static final int USE_DURATION = 20;

    public WormholeMirrorItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack stack) {
        return 20;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (player.m_6144_()) {
            if (!level.f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PacketHandler.RequestPlayerListPacket(false));
            }
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (this.canTeleport(player)) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_6144_()) {
                if (level.f_46443_) {
                    this.openPlayerListGUI(player);
                }
            } else if (this.checkCooldown(player)) {
                this.teleportToSpawn((ServerPlayer)player);
                this.setCooldown(player);
            }
        }
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openPlayerListGUI(Player player) {
        PacketHandler.INSTANCE.sendToServer((Object)new PacketHandler.RequestPlayerListPacket(false));
    }

    public void teleportToPlayer(ServerPlayer sender, String targetName) {
        if (sender.m_36316_().getName().equalsIgnoreCase(targetName)) {
            sender.m_213846_((Component)Component.m_237115_((String)"msg.mirror.self_teleport"));
            return;
        }
        ServerPlayer target = sender.f_8924_.m_6846_().m_11255_(targetName);
        if (target == null) {
            sender.m_213846_((Component)Component.m_237110_((String)"msg.mirror.player_offline", (Object[])new Object[]{targetName}));
            return;
        }
        if (!this.checkCooldown((Player)sender)) {
            return;
        }
        UUID requestId = TeleportRequestManager.addRequest(sender, target);
        Component message = this.createClickableMessage(sender, target, requestId);
        target.m_213846_(message);
        sender.m_213846_((Component)Component.m_237110_((String)"msg.mirror.request_sent", (Object[])new Object[]{targetName}));
        this.setCooldown((Player)sender);
        ItemStack usedStack = sender.m_21205_();
        if (usedStack.m_41720_() == this) {
            sender.m_21008_(InteractionHand.MAIN_HAND, this.handleItemConsumption(usedStack, sender));
        } else {
            usedStack = sender.m_21206_();
            if (usedStack.m_41720_() == this) {
                sender.m_21008_(InteractionHand.OFF_HAND, this.handleItemConsumption(usedStack, sender));
            }
        }
    }

    private Component createClickableMessage(ServerPlayer requester, ServerPlayer target, UUID requestId) {
        MutableComponent acceptBtn = Component.m_237113_((String)"[\u2714]").m_130940_(ChatFormatting.GREEN).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/bountifulbaubles tp_accept " + requestId)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"command.tp_request.accepted").m_130940_(ChatFormatting.GREEN))));
        MutableComponent denyBtn = Component.m_237113_((String)"[\u2716]").m_130940_(ChatFormatting.RED).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/bountifulbaubles tp_deny " + requestId)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"command.tp_request.denied").m_130940_(ChatFormatting.RED))));
        return Component.m_237110_((String)"msg.mirror.request_received", (Object[])new Object[]{requester.m_6302_()}).m_130946_(" ").m_7220_((Component)acceptBtn).m_130946_(" ").m_7220_((Component)denyBtn);
    }

    private boolean canTeleport(Player player) {
        return !player.m_36335_().m_41519_((Item)this);
    }

    protected boolean checkCooldown(Player player) {
        if (player.m_36335_().m_41519_((Item)this)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"message.magic_mirror.cooldown"));
            }
            return false;
        }
        return true;
    }

    public void playTeleportEffects(ServerPlayer player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123760_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 100, 0.5, 0.5, 0.5, 1.0);
    }

    private void teleportToSpawn(ServerPlayer player) {
        ServerLevel targetLevel = player.f_8924_.m_129880_(player.m_8963_());
        BlockPos spawnPos = player.m_8961_();
        float angle = player.m_8962_();
        if (spawnPos == null || targetLevel == null) {
            targetLevel = player.f_8924_.m_129783_();
            spawnPos = targetLevel.m_220360_();
        }
        player.m_8999_(targetLevel, (double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, angle, 0.0f);
        player.f_19789_ = 0.0f;
        this.playTeleportEffects(player);
    }

    private void setCooldown(Player player) {
        player.m_36335_().m_41524_((Item)this, 10);
        if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PacketHandler.SetCooldownPacket(10));
            System.out.println("[SERVER] \u53d1\u9001\u51b7\u5374\u5305\u7ed9 " + serverPlayer.m_7755_().getString());
        }
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }
        });
    }

    protected ItemStack handleItemConsumption(ItemStack stack, ServerPlayer player) {
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.wormhole_mirror.effect").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.wormhole_mirror.effect1").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.wormhole_mirror.description").m_130940_(ChatFormatting.GREEN));
    }
}

