/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.item.Baubles;

import com.jinqinxixi.bountifulbaubles.system.modifier.ModifiableBaubleItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class WrathPendantItem
extends ModifiableBaubleItem {
    private static final String DAMAGE_UUID_KEY = "WrathDamageUUID";
    private static final double DAMAGE_BONUS = 2.0;
    private static final ModifiableBaubleItem.Modifier[] MODIFIERS = ModifiableBaubleItem.Modifier.values();

    @Override
    public ModifiableBaubleItem.Modifier[] getModifiers() {
        return MODIFIERS;
    }

    public WrathPendantItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag unused) {
        return CuriosApi.createCurioProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    WrathPendantItem.this.applyModifier(player, stack);
                    WrathPendantItem.this.applyWrathDamageModifier(player, stack);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    WrathPendantItem.this.removeModifier(player, stack);
                    WrathPendantItem.this.removeWrathDamageModifier(player, stack);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return true;
            }

            public boolean canUnequip(SlotContext slotContext) {
                return true;
            }
        });
    }

    private void initializeDamageUUID(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128403_(DAMAGE_UUID_KEY)) {
            tag.m_128362_(DAMAGE_UUID_KEY, UUID.randomUUID());
        }
    }

    private void applyWrathDamageModifier(Player player, ItemStack stack) {
        this.initializeDamageUUID(stack);
        CompoundTag tag = stack.m_41784_();
        UUID damageUUID = tag.m_128342_(DAMAGE_UUID_KEY);
        AttributeModifier modifier = new AttributeModifier(damageUUID, "WrathPendantDamage", 2.0, AttributeModifier.Operation.ADDITION);
        if (!player.m_21051_(Attributes.f_22281_).m_22109_(modifier)) {
            player.m_21051_(Attributes.f_22281_).m_22125_(modifier);
        }
    }

    private void removeWrathDamageModifier(Player player, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128403_(DAMAGE_UUID_KEY)) {
            UUID damageUUID = tag.m_128342_(DAMAGE_UUID_KEY);
            player.m_21051_(Attributes.f_22281_).m_22120_(damageUUID);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.applyWrathDamageModifier(player, stack);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.wrath_pendant.effect").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bountifulbaubles.wrath_pendant.effect1").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flag);
    }
}

