/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.loot;

import com.jinqinxixi.bountifulbaubles.config.ModConfig;
import com.jinqinxixi.bountifulbaubles.item.ModItems;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="bountifulbaubles", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LootHandler {
    private static final Logger log = LoggerFactory.getLogger(LootHandler.class);

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation tableId = event.getName();
        List<ModConfig.LootEntry> entries = ModConfig.lootConfig.get(tableId);
        if (entries != null && !entries.isEmpty()) {
            LootPool.Builder poolBuilder = LootPool.m_79043_().name("bountifulbaubles_config_loot");
            for (ModConfig.LootEntry entry : entries) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(entry.itemId);
                if (item != null) {
                    poolBuilder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79707_(entry.weight)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)entry.minRolls, (float)entry.maxRolls));
                    continue;
                }
                log.error("Invalid item in config: {}", (Object)entry.itemId);
            }
            event.getTable().addPool(poolBuilder.m_79082_());
            log.debug("Added custom loot to {}", (Object)tableId);
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (!(event.getSource().m_7639_() instanceof Player)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        RandomSource rand = entity.m_217043_();
        LootHandler.handleMobDrops(entity, rand, world);
    }

    private static void handleMobDrops(LivingEntity entity, RandomSource rand, Level world) {
        if (entity instanceof Husk) {
            LootHandler.tryDropItem(entity, rand, world, ModConfig.getHuskAppleChance(), (Item)ModItems.APPLE.get());
        } else if (entity instanceof ElderGuardian) {
            LootHandler.tryDropItem(entity, rand, world, ModConfig.getElderGuardianVitaminChance(), (Item)ModItems.VITAMINS.get());
        } else if (entity instanceof Stray) {
            LootHandler.tryDropItem(entity, rand, world, ModConfig.getStrayRingChance(), (Item)ModItems.RING_OVERCLOCKING.get());
        } else if (entity instanceof Shulker) {
            LootHandler.tryDropItem(entity, rand, world, ModConfig.getShulkerHeartChance(), (Item)ModItems.SHULKER_HEART.get());
        } else if (entity instanceof CaveSpider) {
            LootHandler.tryDropItem(entity, rand, world, ModConfig.getCaveSpiderBezoarChance(), (Item)ModItems.BEZOAR.get());
        } else if (entity instanceof EnderDragon) {
            LootHandler.handleDragonDrops(entity, rand, world);
        } else if (entity instanceof Evoker) {
            LootHandler.tryDropItem(entity, rand, world, ModConfig.getEvokerTotemChance(), (Item)ModItems.INFINITE_TOTEM.get());
        }
    }

    private static void tryDropItem(LivingEntity entity, RandomSource rand, Level world, float chance, Item item) {
        if (rand.m_188501_() < chance) {
            LootHandler.spawnItem(entity, item, 1, world);
        }
    }

    private static void spawnItem(LivingEntity entity, Item item, int count, Level world) {
        ItemStack stack = new ItemStack((ItemLike)item, count);
        world.m_7967_((Entity)new ItemEntity(world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack));
    }

    private static void handleDragonDrops(LivingEntity dragon, RandomSource rand, Level world) {
        if (rand.m_188501_() < ModConfig.getDragonScaleChance()) {
            int count = ModConfig.getDragonScaleMin() + rand.m_188503_(ModConfig.getDragonScaleMax() - ModConfig.getDragonScaleMin() + 1);
            for (int i = 0; i < count; ++i) {
                ItemEntity item = new ItemEntity(world, dragon.m_20185_(), dragon.m_20186_(), dragon.m_20189_(), new ItemStack((ItemLike)ModItems.ENDER_DRAGON_SCALE.get()));
                item.m_20334_((rand.m_188500_() - 0.5) * 0.5, rand.m_188500_() * 0.5 + 0.3, (rand.m_188500_() - 0.5) * 0.5);
                world.m_7967_((Entity)item);
            }
        }
    }

    private static void trySpawnFromPool(LivingEntity entity, RandomSource rand, Level world, float chance, List<ItemEntry> pool) {
        Item item;
        if (rand.m_188501_() < chance && (item = LootHandler.selectFromPool(pool, rand)) != null) {
            LootHandler.spawnItem(entity, item, 1, world);
        }
    }

    private static Item selectFromPool(List<ItemEntry> pool, RandomSource rand) {
        int totalWeight = pool.stream().mapToInt(e -> e.weight).sum();
        int randomValue = rand.m_188503_(totalWeight);
        int cumulative = 0;
        for (ItemEntry entry : pool) {
            if (randomValue >= (cumulative += entry.weight)) continue;
            return entry.item;
        }
        return null;
    }

    private static class ItemEntry {
        final Item item;
        final int weight;

        ItemEntry(Item item, int weight) {
            this.item = item;
            this.weight = weight;
        }
    }
}

