/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.network.packet;

import com.jinqinxixi.bountifulbaubles.item.Baubles.MindsEyeItem;
import java.util.AbstractMap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class MarkTargetPacket {
    private final UUID playerUUID;
    private final int entityId;
    private final long endTime;
    private final boolean shouldClear;
    private final PacketType type;

    public MarkTargetPacket(UUID playerUUID, int entityId, long endTime, boolean shouldClear) {
        this.playerUUID = playerUUID;
        this.entityId = entityId;
        this.endTime = endTime;
        this.shouldClear = shouldClear;
        this.type = shouldClear ? PacketType.CLEAR : PacketType.MARK;
    }

    public MarkTargetPacket(FriendlyByteBuf buf) {
        this.playerUUID = buf.m_130259_();
        this.entityId = buf.readInt();
        this.endTime = buf.readLong();
        this.shouldClear = buf.readBoolean();
        this.type = PacketType.values()[buf.readByte()];
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerUUID);
        buf.writeInt(this.entityId);
        buf.writeLong(this.endTime);
        buf.writeBoolean(this.shouldClear);
        buf.writeByte(this.type.ordinal());
    }

    public static void handle(MarkTargetPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MarkTargetPacket.handleClient(packet));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void handleClient(MarkTargetPacket packet) {
        switch (packet.type) {
            case CLEAR: {
                MindsEyeItem.getMarkedTargets().remove(packet.playerUUID);
                break;
            }
            case MARK: 
            case UPDATE: {
                if (packet.shouldClear) {
                    MindsEyeItem.getMarkedTargets().remove(packet.playerUUID);
                    break;
                }
                MindsEyeItem.getMarkedTargets().put(packet.playerUUID, new AbstractMap.SimpleEntry<Integer, Long>(packet.entityId, packet.endTime));
            }
        }
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean isShouldClear() {
        return this.shouldClear;
    }

    public PacketType getType() {
        return this.type;
    }

    public static enum PacketType {
        MARK,
        CLEAR,
        UPDATE;

    }
}

