/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.system.effect;

import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;

public class SinfulEffect
extends MobEffect {
    private static final UUID DAMAGE_UUID = UUID.fromString("a3b4c5d6-7e8f-49a1-b2c3-d4e5f6a7b8c9");
    private static final UUID ARMOR_UUID = UUID.fromString("d9e8f7a6-b5c4-4d3e-8f1a-9b0c1d2e3f4a");
    private static final UUID TOUGHNESS_UUID = UUID.fromString("1a2b3c4d-5e6f-4a3b-8c7d-6e5f4a3b2c1d");

    public SinfulEffect() {
        super(MobEffectCategory.BENEFICIAL, 0x8B0000);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (!entity.m_9236_().f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            this.removeModifiers(player);
            this.applyModifiers(player, amplifier + 1);
        }
    }

    private void applyModifiers(Player player, int level) {
        AttributeInstance damageAttr = player.m_21051_(Attributes.f_22281_);
        AttributeInstance armorAttr = player.m_21051_(Attributes.f_22284_);
        AttributeInstance toughnessAttr = player.m_21051_(Attributes.f_22285_);
        AttributeModifier damageModifier = new AttributeModifier(DAMAGE_UUID, "sinful_damage", 0.25 * (double)level, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeModifier armorModifier = new AttributeModifier(ARMOR_UUID, "sinful_armor", 3.0 * (double)level, AttributeModifier.Operation.ADDITION);
        AttributeModifier toughnessModifier = new AttributeModifier(TOUGHNESS_UUID, "sinful_toughness", 1.0 * (double)level, AttributeModifier.Operation.ADDITION);
        if (damageAttr != null && !damageAttr.m_22109_(damageModifier)) {
            damageAttr.m_22118_(damageModifier);
        }
        if (armorAttr != null && !armorAttr.m_22109_(armorModifier)) {
            armorAttr.m_22118_(armorModifier);
        }
        if (toughnessAttr != null && !toughnessAttr.m_22109_(toughnessModifier)) {
            toughnessAttr.m_22118_(toughnessModifier);
        }
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        super.m_6386_(entity, attributes, amplifier);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.removeModifiers(player);
        }
    }

    private void removeModifiers(Player player) {
        AttributeInstance damageAttr = player.m_21051_(Attributes.f_22281_);
        AttributeInstance armorAttr = player.m_21051_(Attributes.f_22284_);
        AttributeInstance toughnessAttr = player.m_21051_(Attributes.f_22285_);
        if (damageAttr != null) {
            damageAttr.m_22120_(DAMAGE_UUID);
        }
        if (armorAttr != null) {
            armorAttr.m_22120_(ARMOR_UUID);
        }
        if (toughnessAttr != null) {
            toughnessAttr.m_22120_(TOUGHNESS_UUID);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new IClientMobEffectExtensions(){

            public boolean isVisibleInGui(MobEffectInstance effect) {
                return true;
            }

            public ResourceLocation getIconTexture(MobEffectInstance instance) {
                return new ResourceLocation("bountifulbaubles", "textures/mob_effect/sinful.png");
            }
        });
    }
}

