/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.system.wormhole;

import com.jinqinxixi.bountifulbaubles.item.Baubles.WormholeMirrorItem;
import com.jinqinxixi.bountifulbaubles.item.ModItems;
import com.jinqinxixi.bountifulbaubles.system.wormhole.PlayerSelectionScreen;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "1.0";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("bountifulbaubles", "wormhole_mirror"), () -> "1.0", "1.0"::equals, "1.0"::equals);

    public static void register() {
        int packetId = 0;
        INSTANCE.registerMessage(packetId++, RequestPlayerListPacket.class, RequestPlayerListPacket::encode, RequestPlayerListPacket::decode, (msg, ctx) -> PacketHandler.handlePacket(ctx, () -> PacketHandler.lambda$register$1(msg, (Supplier)ctx)));
        INSTANCE.registerMessage(packetId++, PlayerSelectedPacket.class, PlayerSelectedPacket::encode, PlayerSelectedPacket::decode, (msg, ctx) -> PacketHandler.handlePacket(ctx, () -> PacketHandler.lambda$register$3(msg, (Supplier)ctx)));
        INSTANCE.registerMessage(packetId++, TeleportRequestPacket.class, TeleportRequestPacket::encode, TeleportRequestPacket::decode, (msg, ctx) -> PacketHandler.handlePacket(ctx, () -> PacketHandler.lambda$register$5(msg, (Supplier)ctx)));
        INSTANCE.registerMessage(packetId++, TeleportResponsePacket.class, TeleportResponsePacket::encode, TeleportResponsePacket::decode, (msg, ctx) -> PacketHandler.handlePacket(ctx, () -> PacketHandler.lambda$register$7(msg, (Supplier)ctx)));
        INSTANCE.registerMessage(packetId++, PlayerListResponsePacket.class, PlayerListResponsePacket::encode, PlayerListResponsePacket::decode, (msg, ctx) -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                PacketHandler.handleClientPacket(ctx, () -> PacketHandler.lambda$register$9(msg, (Supplier)ctx));
            }
        });
        INSTANCE.registerMessage(packetId++, SetCooldownPacket.class, SetCooldownPacket::encode, SetCooldownPacket::decode, (msg, ctx) -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                PacketHandler.handleClientPacket(ctx, () -> PacketHandler.lambda$register$11(msg, (Supplier)ctx));
            }
        });
    }

    private static void handlePacket(Supplier<NetworkEvent.Context> ctxSupplier, Runnable handler) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            try {
                System.out.println("[SERVER] \u5904\u7406\u6570\u636e\u5305: " + handler.getClass().getSimpleName());
                handler.run();
            }
            finally {
                ctx.setPacketHandled(true);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClientPacket(Supplier<NetworkEvent.Context> ctxSupplier, Runnable handler) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            try {
                System.out.println("[CLIENT] \u5904\u7406\u5ba2\u6237\u7aef\u6570\u636e\u5305");
                handler.run();
            }
            finally {
                ctx.setPacketHandled(true);
            }
        });
    }

    private static /* synthetic */ void lambda$register$11(SetCooldownPacket msg, Supplier ctx) {
        SetCooldownPacket.handleClient(msg, (NetworkEvent.Context)ctx.get());
    }

    private static /* synthetic */ void lambda$register$9(PlayerListResponsePacket msg, Supplier ctx) {
        PlayerListResponsePacket.handleClient(msg, (NetworkEvent.Context)ctx.get());
    }

    private static /* synthetic */ void lambda$register$7(TeleportResponsePacket msg, Supplier ctx) {
        TeleportResponsePacket.handle(msg, (NetworkEvent.Context)ctx.get());
    }

    private static /* synthetic */ void lambda$register$5(TeleportRequestPacket msg, Supplier ctx) {
        TeleportRequestPacket.handle(msg, (NetworkEvent.Context)ctx.get());
    }

    private static /* synthetic */ void lambda$register$3(PlayerSelectedPacket msg, Supplier ctx) {
        PlayerSelectedPacket.handle(msg, (NetworkEvent.Context)ctx.get());
    }

    private static /* synthetic */ void lambda$register$1(RequestPlayerListPacket msg, Supplier ctx) {
        RequestPlayerListPacket.handle(msg, (NetworkEvent.Context)ctx.get());
    }

    public static class RequestPlayerListPacket {
        private final boolean isFromPotion;

        public RequestPlayerListPacket(boolean isFromPotion) {
            this.isFromPotion = isFromPotion;
        }

        public static void encode(RequestPlayerListPacket msg, FriendlyByteBuf buffer) {
            buffer.writeBoolean(msg.isFromPotion);
        }

        public static RequestPlayerListPacket decode(FriendlyByteBuf buffer) {
            return new RequestPlayerListPacket(buffer.readBoolean());
        }

        public static void handle(RequestPlayerListPacket msg, NetworkEvent.Context ctx) {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            System.out.println("[SERVER] \u6536\u5230\u73a9\u5bb6\u5217\u8868\u8bf7\u6c42 fromPotion=" + msg.isFromPotion);
            if (!msg.isFromPotion) {
                RequestPlayerListPacket.handleCooldown(sender);
            }
            List<String> players = sender.f_8924_.m_6846_().m_11314_().stream().filter(p -> !p.m_36316_().getName().equals(sender.m_36316_().getName())).map(p -> p.m_36316_().getName()).toList();
            RequestPlayerListPacket.sendPlayerList(sender, players);
        }

        private static void handleCooldown(ServerPlayer player) {
            boolean holdingMirror;
            ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
            boolean bl = holdingMirror = mainHand.m_41720_() == ModItems.WORMHOLE_MIRROR.get() || offHand.m_41720_() == ModItems.WORMHOLE_MIRROR.get();
            if (holdingMirror) {
                player.m_36335_().m_41524_((Item)ModItems.WORMHOLE_MIRROR.get(), 2);
            }
        }

        private static void sendPlayerList(ServerPlayer target, List<String> players) {
            System.out.println("[SERVER] \u53d1\u9001\u73a9\u5bb6\u5217\u8868\u7ed9 " + target.m_7755_().getString() + ": " + players);
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> target), (Object)new PlayerListResponsePacket(players));
        }
    }

    public static class PlayerSelectedPacket {
        private final String playerName;

        public PlayerSelectedPacket(String playerName) {
            this.playerName = playerName;
        }

        public static void encode(PlayerSelectedPacket msg, FriendlyByteBuf buffer) {
            buffer.m_130070_(msg.playerName);
        }

        public static PlayerSelectedPacket decode(FriendlyByteBuf buffer) {
            return new PlayerSelectedPacket(buffer.m_130277_());
        }

        public static void handle(PlayerSelectedPacket msg, NetworkEvent.Context ctx) {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item item = stack.m_41720_();
            if (item instanceof WormholeMirrorItem) {
                WormholeMirrorItem mirror = (WormholeMirrorItem)item;
                mirror.teleportToPlayer(player, msg.playerName);
            }
        }
    }

    public static class TeleportRequestPacket {
        private final String requesterName;
        private final String targetName;

        public TeleportRequestPacket(String requesterName, String targetName) {
            this.requesterName = requesterName;
            this.targetName = targetName;
        }

        public static void encode(TeleportRequestPacket msg, FriendlyByteBuf buffer) {
            buffer.m_130070_(msg.requesterName);
            buffer.m_130070_(msg.targetName);
        }

        public static TeleportRequestPacket decode(FriendlyByteBuf buffer) {
            return new TeleportRequestPacket(buffer.m_130277_(), buffer.m_130277_());
        }

        public static void handle(TeleportRequestPacket msg, NetworkEvent.Context ctx) {
            ServerPlayer target = ctx.getSender().f_8924_.m_6846_().m_11255_(msg.targetName);
            if (target != null) {
                INSTANCE.send(PacketDistributor.PLAYER.with(() -> target), (Object)new TeleportNotificationPacket(msg.requesterName));
            }
        }
    }

    public static class TeleportResponsePacket {
        private final boolean accepted;
        private final String requesterName;
        private final String targetName;

        public TeleportResponsePacket(boolean accepted, String requesterName, String targetName) {
            this.accepted = accepted;
            this.requesterName = requesterName;
            this.targetName = targetName;
        }

        public static void encode(TeleportResponsePacket msg, FriendlyByteBuf buffer) {
            buffer.writeBoolean(msg.accepted);
            buffer.m_130070_(msg.requesterName);
            buffer.m_130070_(msg.targetName);
        }

        public static TeleportResponsePacket decode(FriendlyByteBuf buffer) {
            return new TeleportResponsePacket(buffer.readBoolean(), buffer.m_130277_(), buffer.m_130277_());
        }

        public static void handle(TeleportResponsePacket msg, NetworkEvent.Context ctx) {
            ServerPlayer requester = ctx.getSender().f_8924_.m_6846_().m_11255_(msg.requesterName);
            ServerPlayer target = ctx.getSender().f_8924_.m_6846_().m_11255_(msg.targetName);
            if (msg.accepted && requester != null && target != null) {
                requester.m_8999_(target.m_284548_(), target.m_20185_(), target.m_20186_(), target.m_20189_(), target.m_146908_(), target.m_146909_());
                ((WormholeMirrorItem)((Object)ModItems.WORMHOLE_MIRROR.get())).playTeleportEffects(requester);
            }
        }
    }

    public static class PlayerListResponsePacket {
        private final List<String> players;

        public PlayerListResponsePacket(List<String> players) {
            this.players = players;
        }

        public static void encode(PlayerListResponsePacket msg, FriendlyByteBuf buffer) {
            buffer.m_236828_(msg.players, FriendlyByteBuf::m_130070_);
        }

        public static PlayerListResponsePacket decode(FriendlyByteBuf buffer) {
            return new PlayerListResponsePacket(buffer.m_236845_(FriendlyByteBuf::m_130277_));
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void handleClient(PlayerListResponsePacket msg, NetworkEvent.Context ctx) {
            Minecraft.m_91087_().execute(() -> {
                System.out.println("[CLIENT] \u6536\u5230\u73a9\u5bb6\u5217\u8868: " + msg.players);
                if (Minecraft.m_91087_().f_91080_ == null) {
                    Minecraft.m_91087_().m_91152_((Screen)new PlayerSelectionScreen(msg.players));
                }
            });
        }
    }

    public static class SetCooldownPacket {
        private final int ticks;

        public SetCooldownPacket(int ticks) {
            this.ticks = ticks;
        }

        public static void encode(SetCooldownPacket msg, FriendlyByteBuf buffer) {
            buffer.writeInt(msg.ticks);
        }

        public static SetCooldownPacket decode(FriendlyByteBuf buffer) {
            return new SetCooldownPacket(buffer.readInt());
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void handleClient(SetCooldownPacket msg, NetworkEvent.Context ctx) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            System.out.println("[CLIENT] \u8bbe\u7f6e\u51b7\u5374: " + msg.ticks + " ticks");
            if (player != null) {
                player.m_36335_().m_41524_((Item)ModItems.WORMHOLE_MIRROR.get(), msg.ticks);
            }
        }
    }

    public static class TeleportNotificationPacket {
        private final String requesterName;

        public TeleportNotificationPacket(String requesterName) {
            this.requesterName = requesterName;
        }

        public static void encode(TeleportNotificationPacket msg, FriendlyByteBuf buffer) {
            buffer.m_130070_(msg.requesterName);
        }

        public static TeleportNotificationPacket decode(FriendlyByteBuf buffer) {
            return new TeleportNotificationPacket(buffer.m_130277_());
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void handleClient(TeleportNotificationPacket msg, NetworkEvent.Context ctx) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.m_213846_((Component)Component.m_237110_((String)"msg.mirror.request_received", (Object[])new Object[]{msg.requesterName}));
            }
        }
    }
}

