/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.bountifulbaubles.system.wormhole;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class TeleportRequestManager {
    private static final Map<UUID, TeleportRequest> REQUESTS = new ConcurrentHashMap<UUID, TeleportRequest>();

    public static UUID addRequest(ServerPlayer requester, ServerPlayer target) {
        UUID requestId = UUID.randomUUID();
        REQUESTS.put(requestId, new TeleportRequest(requester, target));
        return requestId;
    }

    public static void checkExpiredRequests() {
        long now = System.currentTimeMillis();
        REQUESTS.entrySet().removeIf(entry -> {
            TeleportRequest request = (TeleportRequest)entry.getValue();
            if (now - request.createTime > 30000L) {
                if (request.isValid()) {
                    TeleportRequestManager.notifyExpired(request);
                }
                return true;
            }
            return false;
        });
    }

    private static void notifyExpired(TeleportRequest request) {
        if (request.requester.m_6084_() && !request.requester.m_9232_()) {
            request.requester.m_213846_((Component)Component.m_237110_((String)"msg.mirror.request_expired", (Object[])new Object[]{request.target.m_6302_()}).m_130940_(ChatFormatting.GOLD));
        }
        if (request.target.m_6084_() && !request.target.m_9232_()) {
            request.target.m_213846_((Component)Component.m_237110_((String)"msg.mirror.request_expired", (Object[])new Object[]{request.requester.m_6302_()}).m_130940_(ChatFormatting.GOLD));
        }
    }

    public static void removeRequest(UUID requestId) {
        REQUESTS.remove(requestId);
    }

    public static TeleportRequest getRequest(UUID requestId) {
        return REQUESTS.get(requestId);
    }

    public static class TeleportRequest {
        public final ServerPlayer requester;
        public final ServerPlayer target;
        public final long createTime;

        public TeleportRequest(ServerPlayer requester, ServerPlayer target) {
            this.requester = requester;
            this.target = target;
            this.createTime = System.currentTimeMillis();
        }

        public boolean isValid() {
            return !this.requester.m_9232_() && !this.target.m_9232_() && this.requester.m_6084_() && this.target.m_6084_();
        }
    }
}

