/*
 * Decompiled with CFR 0.152.
 */
package net.fretux.skillengine.compat;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fretux.ascend.player.PlayerStatsProvider;
import net.fretux.skillengine.capability.SkillEngineCapabilities;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="skillengine")
public class AscendCompatHandler {
    private static final int SKILL_POINTS_PER_ASCEND_LEVEL = 5;
    private static final Map<UUID, Integer> LAST_ASCEND_LEVEL = new ConcurrentHashMap<UUID, Integer>();

    private static void initAscendLevel(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(ascendStats -> {
            int currentLevel = ascendStats.getAscendLevel();
            LAST_ASCEND_LEVEL.put(player.m_20148_(), currentLevel);
        });
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        AscendCompatHandler.initAscendLevel(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Player newPlayer = event.getEntity();
        Player original = event.getOriginal();
        int last = LAST_ASCEND_LEVEL.getOrDefault(original.m_20148_(), 1);
        LAST_ASCEND_LEVEL.put(newPlayer.m_20148_(), last);
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        AscendCompatHandler.initAscendLevel(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().f_46443_) {
            return;
        }
        player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(ascendStats -> {
            int lastLevel;
            int currentLevel = ascendStats.getAscendLevel();
            if (currentLevel > (lastLevel = LAST_ASCEND_LEVEL.getOrDefault(player.m_20148_(), currentLevel).intValue())) {
                int levelsGained = currentLevel - lastLevel;
                int pointsToGive = levelsGained * 5;
                player.getCapability(SkillEngineCapabilities.PLAYER_SKILLS).ifPresent(skillData -> skillData.addSkillPoints(pointsToGive));
            }
            LAST_ASCEND_LEVEL.put(player.m_20148_(), currentLevel);
        });
    }
}

