/*
 * Decompiled with CFR 0.152.
 */
package net.fretux.skillengine.network;

import java.util.function.Supplier;
import net.fretux.skillengine.SkillEngine;
import net.fretux.skillengine.capability.SkillEngineCapabilities;
import net.fretux.skillengine.network.ClientboundNodeUnlockedPacket;
import net.fretux.skillengine.network.PacketHandler;
import net.fretux.skillengine.skilltree.SkillLogic;
import net.fretux.skillengine.skilltree.SkillNode;
import net.fretux.skillengine.skilltree.SkillNodeRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ServerboundUnlockNodePacket {
    private final ResourceLocation nodeId;

    public ServerboundUnlockNodePacket(ResourceLocation nodeId) {
        this.nodeId = nodeId;
    }

    public static void encode(ServerboundUnlockNodePacket msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.nodeId);
    }

    public static ServerboundUnlockNodePacket decode(FriendlyByteBuf buf) {
        return new ServerboundUnlockNodePacket(buf.m_130281_());
    }

    public static void handle(ServerboundUnlockNodePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                SkillEngine.LOGGER.warn("Unlock packet received but sender was null");
                return;
            }
            SkillNode node = SkillNodeRegistry.get(msg.nodeId);
            if (node == null) {
                SkillEngine.LOGGER.warn("Unlock packet for unknown node {}", (Object)msg.nodeId);
                return;
            }
            player.getCapability(SkillEngineCapabilities.PLAYER_SKILLS).ifPresent(data -> {
                SkillEngine.LOGGER.info("Received unlock request for {} from {} (points={})", new Object[]{msg.nodeId, player.m_36316_().getName(), data.getSkillPoints()});
                if (SkillLogic.canUnlock(data, (Player)player, node)) {
                    data.unlockNode(node);
                    SkillEngine.LOGGER.info("Node {} unlocked for {}", (Object)msg.nodeId, (Object)player.m_36316_().getName());
                    PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundNodeUnlockedPacket(node.getId()));
                } else {
                    SkillEngine.LOGGER.info("Cannot unlock node {} for {} (canUnlock=false)", (Object)msg.nodeId, (Object)player.m_36316_().getName());
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

