/*
 * Decompiled with CFR 0.152.
 */
package net.fretux.skillengine.skilltree;

import java.util.Map;
import net.fretux.ascend.player.PlayerStatsProvider;
import net.fretux.skillengine.capability.PlayerSkillData;
import net.fretux.skillengine.skilltree.SkillNode;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SkillLogic {
    public static boolean canUnlock(PlayerSkillData data, Player player, SkillNode node) {
        if (data.isUnlocked(node.getId())) {
            return false;
        }
        if (data.getSkillPoints() < node.getCost()) {
            return false;
        }
        if (node.isRoot()) {
            return true;
        }
        if (!SkillLogic.meetsAscendPrerequisites(player, node)) {
            return false;
        }
        for (ResourceLocation neighborId : node.getLinks()) {
            if (!data.isUnlocked(neighborId)) continue;
            return true;
        }
        return false;
    }

    public static boolean meetsAscendPrerequisites(Player player, SkillNode node) {
        return player.getCapability(PlayerStatsProvider.PLAYER_STATS).map(stats -> {
            for (Map.Entry<String, Integer> req : node.getPrereqAttributes().entrySet()) {
                int current = stats.getAttributeLevel(req.getKey());
                if (current >= req.getValue()) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }
}

