/*
 * Decompiled with CFR 0.152.
 */
package net.fretux.skillengine.skilltree;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fretux.skillengine.SkillEngine;
import net.fretux.skillengine.skilltree.SkillNode;
import net.fretux.skillengine.skilltree.SkillNodeRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="skillengine", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SkillNodeLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();

    public SkillNodeLoader() {
        super(GSON, "skillnodes");
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SkillNodeLoader());
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        SkillEngine.LOGGER.info("Loading skill nodes...");
        SkillNodeRegistry.clear();
        jsons.forEach((id, element) -> {
            JsonObject obj = element.getAsJsonObject();
            String title = obj.get("title").getAsString();
            String description = obj.get("description").getAsString();
            int cost = obj.get("cost").getAsInt();
            JsonObject pos = obj.getAsJsonObject("position");
            float x = pos.get("x").getAsFloat();
            float y = pos.get("y").getAsFloat();
            ArrayList<ResourceLocation> links = new ArrayList<ResourceLocation>();
            obj.getAsJsonArray("links").forEach(e -> links.add(new ResourceLocation(e.getAsString())));
            ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>();
            obj.getAsJsonArray("tags").forEach(e -> tags.add(new ResourceLocation(e.getAsString())));
            ResourceLocation icons = new ResourceLocation(obj.get("icons").getAsString());
            HashMap<String, Integer> prereqAttributes = new HashMap<String, Integer>();
            if (obj.has("prerequisites")) {
                JsonObject prereqObj = obj.getAsJsonObject("prerequisites");
                for (Map.Entry entry : prereqObj.entrySet()) {
                    prereqAttributes.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                }
            }
            SkillNode node = new SkillNode((ResourceLocation)id, (Component)Component.m_237113_((String)title), (Component)Component.m_237113_((String)description), cost, x, y, (List<ResourceLocation>)links, (List<ResourceLocation>)tags, icons, (Map<String, Integer>)prereqAttributes);
            SkillNodeRegistry.put(node);
        });
        SkillEngine.LOGGER.info("Loaded {} skill nodes", (Object)SkillNodeRegistry.all().size());
    }
}

