/*
 * Decompiled with CFR 0.152.
 */
package net.fretux.skillengine.capability;

import java.util.HashSet;
import java.util.Set;
import net.fretux.skillengine.skilltree.SkillNode;
import net.fretux.skillengine.skilltree.SkillNodeRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class PlayerSkillData {
    private int skillPoints;
    private final Set<ResourceLocation> unlockedNodes = new HashSet<ResourceLocation>();
    private final Set<ResourceLocation> activeTags = new HashSet<ResourceLocation>();

    public int getSkillPoints() {
        return this.skillPoints;
    }

    public void addSkillPoints(int amount) {
        this.skillPoints += amount;
    }

    public boolean isUnlocked(ResourceLocation nodeId) {
        return this.unlockedNodes.contains(nodeId);
    }

    public boolean hasTag(ResourceLocation tag) {
        return this.activeTags.contains(tag);
    }

    public Set<ResourceLocation> getActiveTags() {
        return this.activeTags;
    }

    public void unlockNode(SkillNode node) {
        if (this.unlockedNodes.add(node.getId())) {
            this.activeTags.addAll(node.getTags());
            this.skillPoints -= node.getCost();
        }
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("SkillPoints", this.skillPoints);
        ListTag unlockedList = new ListTag();
        for (ResourceLocation id : this.unlockedNodes) {
            CompoundTag t = new CompoundTag();
            t.m_128359_("Id", id.toString());
            unlockedList.add((Object)t);
        }
        tag.m_128365_("Unlocked", (Tag)unlockedList);
        ListTag tagList = new ListTag();
        for (ResourceLocation id : this.activeTags) {
            CompoundTag t = new CompoundTag();
            t.m_128359_("Tag", id.toString());
            tagList.add((Object)t);
        }
        tag.m_128365_("Tags", (Tag)tagList);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.skillPoints = tag.m_128451_("SkillPoints");
        this.unlockedNodes.clear();
        this.activeTags.clear();
        ListTag unlockedList = tag.m_128437_("Unlocked", 10);
        for (Tag t : unlockedList) {
            CompoundTag c = (CompoundTag)t;
            this.unlockedNodes.add(new ResourceLocation(c.m_128461_("Id")));
        }
        ListTag tagList = tag.m_128437_("Tags", 10);
        for (Tag t : tagList) {
            CompoundTag c = (CompoundTag)t;
            this.activeTags.add(new ResourceLocation(c.m_128461_("Tag")));
        }
    }

    public Set<ResourceLocation> getUnlockedNodes() {
        return this.unlockedNodes;
    }

    public int getTotalSkillCost() {
        int total = 0;
        for (ResourceLocation id : this.unlockedNodes) {
            SkillNode node = SkillNodeRegistry.get(id);
            if (node == null) continue;
            total += node.getCost();
        }
        return total;
    }

    public void clearAllNodes() {
        this.unlockedNodes.clear();
        this.activeTags.clear();
    }
}

