/*
 * Decompiled with CFR 0.152.
 */
package net.fretux.skillengine.client;

import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fretux.ascend.player.PlayerStatsProvider;
import net.fretux.skillengine.client.SkilltreeClientState;
import net.fretux.skillengine.network.PacketHandler;
import net.fretux.skillengine.network.ServerboundUnlockNodePacket;
import net.fretux.skillengine.skilltree.SkillNode;
import net.fretux.skillengine.skilltree.SkillNodeRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SkilltreeScreen
extends Screen {
    private float zoom = 1.0f;
    private float minZoom = 0.5f;
    private float maxZoom = 2.0f;
    private double panX = 0.0;
    private double panY = 0.0;
    private boolean dragging = false;
    private double lastMouseX;
    private double lastMouseY;
    private SkillNode hoveredNode = null;
    private SkillNode selectedNode = null;

    public SkilltreeScreen() {
        super((Component)Component.m_237113_((String)"Ascend Skilltree"));
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.zoom = (float)((double)this.zoom + delta * (double)0.1f);
        this.zoom = Mth.m_14036_((float)this.zoom, (float)this.minZoom, (float)this.maxZoom);
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.selectedNode != null) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        if (button == 0) {
            SkillNode clicked = this.findNodeAt(mouseX, mouseY);
            if (clicked != null) {
                if (SkilltreeClientState.isUnlocked(clicked.getId())) {
                    return true;
                }
                this.selectedNode = clicked;
                this.rebuildOverlayButtons();
                return true;
            }
            this.dragging = true;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.selectedNode != null) {
            return super.m_7979_(mouseX, mouseY, button, dx, dy);
        }
        if (this.dragging && button == 0) {
            this.panX += dx;
            this.panY += dy;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dx, dy);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.dragging = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gfx);
        int remaining = SkilltreeClientState.getCurrentSkillPoints();
        MutableComponent pointsText = Component.m_237113_((String)(remaining + " skillpoints remaining")).m_130940_(ChatFormatting.YELLOW);
        gfx.m_280430_(this.f_96547_, (Component)pointsText, 10, 10, 0xFFFFFF);
        this.hoveredNode = this.findNodeAt(mouseX, mouseY);
        this.drawGraph(gfx);
        if (this.hoveredNode != null && this.selectedNode == null) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(this.hoveredNode.getTitle());
            String desc = this.hoveredNode.getDescription().getString();
            List wrapped = this.f_96547_.m_92865_().m_92432_(desc, 220, this.hoveredNode.getDescription().m_7383_());
            for (FormattedText ft : wrapped) {
                tooltip.add(Component.m_237113_((String)ft.getString()).m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add(Component.m_237113_((String)("Cost: " + this.hoveredNode.getCost())).m_130940_(ChatFormatting.DARK_AQUA));
            if (!this.hoveredNode.getPrereqAttributes().isEmpty()) {
                tooltip.add(Component.m_237113_((String)"Requirements:").m_130940_(ChatFormatting.GOLD));
                Minecraft.m_91087_().f_91074_.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> this.hoveredNode.getPrereqAttributes().forEach((attr, required) -> {
                    int current = stats.getAttributeLevel(attr);
                    boolean ok = current >= required;
                    tooltip.add(Component.m_237113_((String)(" - " + attr + ": " + current + "/" + required)).m_130940_(ok ? ChatFormatting.GREEN : ChatFormatting.RED));
                }));
            }
            gfx.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
        }
        if (this.selectedNode != null) {
            this.renderOverlay(gfx, this.selectedNode);
        }
        super.m_88315_(gfx, mouseX, mouseY, partialTicks);
    }

    private void drawGraph(GuiGraphics gfx) {
        for (SkillNode node : SkillNodeRegistry.all()) {
            int[] p1 = this.worldToScreen(node.getX(), node.getY());
            for (ResourceLocation neighborId : node.getLinks()) {
                SkillNode neighbor = SkillNodeRegistry.get(neighborId);
                if (neighbor == null) continue;
                int[] p2 = this.worldToScreen(neighbor.getX(), neighbor.getY());
                boolean bothUnlocked = SkilltreeClientState.isUnlocked(node.getId()) && SkilltreeClientState.isUnlocked(neighbor.getId());
                int linkColor = bothUnlocked ? -7798904 : -10066330;
                this.drawLine(gfx, p1[0], p1[1], p2[0], p2[1], linkColor);
            }
        }
        for (SkillNode node : SkillNodeRegistry.all()) {
            int color;
            int[] pos = this.worldToScreen(node.getX(), node.getY());
            int r = 12;
            boolean unlocked = SkilltreeClientState.isUnlocked(node.getId());
            int n = color = unlocked ? -12268476 : -12303292;
            if (node == this.hoveredNode) {
                color = -8947849;
            }
            if (node == this.selectedNode) {
                color = -6710989;
            }
            gfx.m_280509_(pos[0] - r, pos[1] - r, pos[0] + r, pos[1] + r, color);
            ResourceLocation icon = node.getIcons();
            if (icon == null) continue;
            int size = 16;
            gfx.m_280163_(icon, pos[0] - size / 2, pos[1] - size / 2, 0.0f, 0.0f, size, size, size, size);
        }
    }

    private int[] worldToScreen(float wx, float wy) {
        double sx = (double)this.f_96543_ / 2.0 + this.panX + (double)(wx * this.zoom);
        double sy = (double)this.f_96544_ / 2.0 + this.panY - (double)(wy * this.zoom);
        return new int[]{(int)sx, (int)sy};
    }

    private SkillNode findNodeAt(double mouseX, double mouseY) {
        for (SkillNode node : SkillNodeRegistry.all()) {
            int r;
            int[] pos = this.worldToScreen(node.getX(), node.getY());
            if (!(mouseX >= (double)(pos[0] - (r = 12))) || !(mouseX <= (double)(pos[0] + r)) || !(mouseY >= (double)(pos[1] - r)) || !(mouseY <= (double)(pos[1] + r))) continue;
            return node;
        }
        return null;
    }

    private void renderOverlay(GuiGraphics gfx, SkillNode node) {
        int w = 240;
        int h = 180;
        int x = (this.f_96543_ - w) / 2;
        int y = (this.f_96544_ - h) / 2;
        gfx.m_280509_(0, 0, this.f_96543_, this.f_96544_, -2013265920);
        gfx.m_280509_(x, y, x + w, y + h, -14540254);
        gfx.m_280653_(this.f_96547_, node.getTitle(), x + w / 2, y + 10, 0xFFFFFF);
        gfx.m_280554_(this.f_96547_, (FormattedText)node.getDescription(), x + 10, y + 30, w - 20, 0xDDDDDD);
        int[] textY = new int[]{y + 95};
        gfx.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)("Cost: " + node.getCost() + " skill points")).m_130940_(ChatFormatting.AQUA), x + 10, textY[0], 0xAAAAAA);
        textY[0] = textY[0] + 15;
        if (!node.getPrereqAttributes().isEmpty()) {
            gfx.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"Requirements:").m_130940_(ChatFormatting.GOLD), x + 10, textY[0], 0xFFFFFF);
            textY[0] = textY[0] + 12;
            Minecraft.m_91087_().f_91074_.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                for (Map.Entry<String, Integer> entry : node.getPrereqAttributes().entrySet()) {
                    String attr = entry.getKey();
                    int required = entry.getValue();
                    int current = stats.getAttributeLevel(attr);
                    boolean ok = current >= required;
                    MutableComponent line = Component.m_237113_((String)(" - " + attr + ": " + current + "/" + required)).m_130940_(ok ? ChatFormatting.GREEN : ChatFormatting.RED);
                    gfx.m_280430_(this.f_96547_, (Component)line, x + 10, textY[0], 0xFFFFFF);
                    textY[0] = textY[0] + 12;
                }
            });
        }
    }

    private void rebuildOverlayButtons() {
        this.m_169413_();
        if (this.selectedNode == null) {
            return;
        }
        int w = 240;
        int h = 160;
        int x = (this.f_96543_ - w) / 2;
        int y = (this.f_96544_ - h) / 2;
        boolean alreadyUnlocked = SkilltreeClientState.isUnlocked(this.selectedNode.getId());
        if (!alreadyUnlocked) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Unlock"), btn -> {
                PacketHandler.CHANNEL.sendToServer((Object)new ServerboundUnlockNodePacket(this.selectedNode.getId()));
                this.selectedNode = null;
                this.m_169413_();
            }).m_252794_(x + w / 2 - 40, y + h - 20).m_253046_(80, 20).m_253136_());
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), btn -> {
            this.selectedNode = null;
            this.m_169413_();
        }).m_252794_(x + w - 60, y - 5).m_253046_(50, 20).m_253136_());
    }

    private void drawLine(GuiGraphics gfx, int x1, int y1, int x2, int y2, int color) {
        float thickness = 2.0f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        float length = (float)Math.sqrt(dx * dx + dy * dy);
        float angle = (float)Math.atan2(dy, dx);
        gfx.m_280168_().m_85836_();
        gfx.m_280168_().m_252880_((float)x1, (float)y1, 0.0f);
        gfx.m_280168_().m_252781_(Axis.f_252403_.m_252961_(angle));
        gfx.m_280509_(0, (int)(-thickness / 2.0f), (int)length, (int)(thickness / 2.0f), color);
        gfx.m_280168_().m_85849_();
    }

    public boolean m_7043_() {
        return false;
    }
}

