/*
 * Decompiled with CFR 0.152.
 */
package net.fretux.skillengine.events;

import net.fretux.skillengine.capability.SkillEngineCapabilities;
import net.fretux.skillengine.network.ClientboundSyncSkillsPacket;
import net.fretux.skillengine.network.PacketHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="skillengine", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SkillEnginePlayerEvents {
    private static void sync(ServerPlayer player) {
        player.getCapability(SkillEngineCapabilities.PLAYER_SKILLS).ifPresent(data -> PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundSyncSkillsPacket(data.getUnlockedNodes(), data.getSkillPoints())));
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SkillEnginePlayerEvents.sync(player2);
        }
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SkillEnginePlayerEvents.sync(player2);
        }
    }

    @SubscribeEvent
    public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SkillEnginePlayerEvents.sync(player2);
        }
    }
}

