/*
 * Decompiled with CFR 0.152.
 */
package net.fretux.skillengine.network;

import java.util.function.Supplier;
import net.fretux.skillengine.client.SkilltreeClientState;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundNodeUnlockedPacket {
    private final ResourceLocation id;
    private final int newSkillPoints;

    public ClientboundNodeUnlockedPacket(ResourceLocation id, int newSkillPoints) {
        this.id = id;
        this.newSkillPoints = newSkillPoints;
    }

    public static void encode(ClientboundNodeUnlockedPacket msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.id);
        buf.writeInt(msg.newSkillPoints);
    }

    public static ClientboundNodeUnlockedPacket decode(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        int points = buf.readInt();
        return new ClientboundNodeUnlockedPacket(id, points);
    }

    public static void handle(ClientboundNodeUnlockedPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            SkilltreeClientState.unlockNode(msg.id);
            SkilltreeClientState.setCurrentSkillPoints(msg.newSkillPoints);
        });
        ctx.get().setPacketHandled(true);
    }
}

