/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.mixin.iris;

import dev.djefrey.colorwheel.accessors.PackShadowDirectivesAccessor;
import dev.djefrey.colorwheel.accessors.ProgramSetAccessor;
import dev.djefrey.colorwheel.accessors.ShaderPackAccessor;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramId;
import dev.djefrey.colorwheel.shaderpack.ClrwlShaderProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.irisshaders.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.shaderpack.include.AbsolutePackPath;
import net.irisshaders.iris.shaderpack.loading.ProgramId;
import net.irisshaders.iris.shaderpack.parsing.ConstDirectiveParser;
import net.irisshaders.iris.shaderpack.parsing.DispatchingDirectiveHolder;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.irisshaders.iris.shaderpack.programs.ProgramSource;
import net.irisshaders.iris.shaderpack.properties.PackDirectives;
import net.irisshaders.iris.shaderpack.properties.ShaderProperties;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ProgramSet.class})
public abstract class ProgramSetMixin
implements ProgramSetAccessor {
    @Shadow
    @Final
    private PackDirectives packDirectives;
    @Unique
    @Final
    private Map<ClrwlProgramId, ProgramSource> colorwheel$programSrcs = new HashMap<ClrwlProgramId, ProgramSource>();
    @Unique
    private boolean colorwheel$isFallbackMode = false;

    @Shadow
    public abstract Optional<ProgramSource> get(ProgramId var1);

    @Shadow
    private static ProgramSource readProgramSource(AbsolutePackPath directory, Function<AbsolutePackPath, String> sourceProvider, String program, ProgramSet programSet, ShaderProperties properties, boolean readTesselation) {
        throw new RuntimeException();
    }

    @Inject(method={"<init>(Lnet/irisshaders/iris/shaderpack/include/AbsolutePackPath;Ljava/util/function/Function;Lnet/irisshaders/iris/shaderpack/properties/ShaderProperties;Lnet/irisshaders/iris/shaderpack/ShaderPack;)V"}, at={@At(value="RETURN")})
    private void injectInit(AbsolutePackPath directory, Function<AbsolutePackPath, String> sourceProvider, ShaderProperties shaderProperties, ShaderPack pack, CallbackInfo ci) {
        Optional clrwlGbuffers = ProgramSetMixin.readProgramSource(directory, sourceProvider, ClrwlProgramId.GBUFFERS.programName(), (ProgramSet)this, shaderProperties, false).requireValid();
        if (clrwlGbuffers.isPresent()) {
            this.colorwheel$programSrcs.put(ClrwlProgramId.GBUFFERS, (ProgramSource)clrwlGbuffers.get());
            for (ClrwlProgramId program : ClrwlProgramId.values()) {
                if (program == ClrwlProgramId.GBUFFERS) continue;
                ProgramSetMixin.readProgramSource(directory, sourceProvider, program.programName(), (ProgramSet)this, shaderProperties, false).requireValid().ifPresent(programSource -> this.colorwheel$programSrcs.put(program, (ProgramSource)programSource));
            }
        } else {
            this.colorwheel$isFallbackMode = true;
            for (ClrwlProgramId program : ClrwlProgramId.values()) {
                this.colorwheel$getFallbackProgramSrc(program.fallbackProgram()).ifPresent(programSource -> this.colorwheel$programSrcs.put(program, (ProgramSource)programSource));
            }
        }
        this.colorwheel$locateClrwlDirectives();
        ClrwlShaderProperties clrwlProperties = ((ShaderPackAccessor)pack).colorwheel$getProperties();
        if (clrwlProperties != null) {
            ((PackShadowDirectivesAccessor)this.packDirectives.getShadowDirectives()).colorwheel$setFlywheelShadowRendering(clrwlProperties.shouldRenderShadow());
        }
    }

    @Unique
    private Optional<ProgramSource> colorwheel$getFallbackProgramSrc(@Nullable ProgramId programId) {
        if (programId == null) {
            return Optional.empty();
        }
        Optional<ProgramSource> src = this.get(programId);
        if (src.isPresent()) {
            return src;
        }
        return this.colorwheel$getFallbackProgramSrc(programId.getFallback().orElse(null));
    }

    @Unique
    private void colorwheel$locateClrwlDirectives() {
        DispatchingDirectiveHolder packDirectiveHolder = new DispatchingDirectiveHolder();
        for (ProgramSource source : this.colorwheel$programSrcs.values()) {
            if (source == null) continue;
            source.getFragmentSource().map(ConstDirectiveParser::findDirectives).ifPresent(directives -> {
                for (ConstDirectiveParser.ConstDirective directive : directives) {
                    packDirectiveHolder.processDirective(directive);
                }
            });
        }
    }

    @Override
    public Optional<ClrwlProgramId> colorwheel$getRealClrwlProgram(ClrwlProgramId programId) {
        for (ClrwlProgramId cur = programId; cur != null; cur = cur.base()) {
            if (!this.colorwheel$programSrcs.containsKey((Object)cur)) continue;
            return Optional.of(cur);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ProgramId> colorwheel$getRealFallbackProgram(ClrwlProgramId programId) {
        ClrwlProgramId clrwlCur;
        for (clrwlCur = programId; clrwlCur != null && clrwlCur.fallbackProgram() == null; clrwlCur = clrwlCur.base()) {
        }
        if (clrwlCur == null) {
            return Optional.empty();
        }
        Optional cur = Optional.of(clrwlCur.fallbackProgram());
        while (cur.isPresent()) {
            if (this.get(cur.get()).isPresent()) {
                return cur;
            }
            cur = cur.get().getFallback();
        }
        return Optional.empty();
    }

    @Override
    public Optional<ProgramSource> colorwheel$getClrwlProgramSource(ClrwlProgramId programId) {
        for (ClrwlProgramId cur = programId; cur != null; cur = cur.base()) {
            ProgramSource nullableSrc = this.colorwheel$programSrcs.get((Object)cur);
            if (nullableSrc == null) continue;
            return Optional.of(nullableSrc);
        }
        return Optional.empty();
    }

    @Override
    @Unique
    public boolean colorwheel$isFallbackMode() {
        return this.colorwheel$isFallbackMode;
    }
}

