/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.compile;

import dev.djefrey.colorwheel.ShaderType;
import dev.djefrey.colorwheel.compile.ClrwlCompilation;
import dev.engine_room.flywheel.backend.glsl.ShaderSources;
import dev.engine_room.flywheel.backend.glsl.SourceComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.irisshaders.iris.helpers.StringPair;
import net.minecraft.class_2960;

public record ClrwlPipelineStage<K>(ShaderType type, List<String> extensions, List<StringPair> defines, List<BiFunction<K, ClrwlCompilation, SourceComponent>> fetchers, BiConsumer<K, ClrwlCompilation> compile) {

    public static class Builder<K> {
        private final ShaderType type;
        private final List<String> extensions = new ArrayList<String>();
        private final List<StringPair> defines = new ArrayList<StringPair>();
        private final List<BiFunction<K, ClrwlCompilation, SourceComponent>> fetchers = new ArrayList<BiFunction<K, ClrwlCompilation, SourceComponent>>();
        private BiConsumer<K, ClrwlCompilation> compileCallbacks = ($, $$) -> {};

        public Builder(ShaderType type) {
            this.type = type;
        }

        public Builder<K> enableExtension(String ext) {
            this.extensions.add(ext);
            return this;
        }

        public Builder<K> define(StringPair pair) {
            this.defines.add(pair);
            return this;
        }

        public Builder<K> define(String define) {
            return this.define(new StringPair(define, ""));
        }

        public Builder<K> with(BiFunction<K, ClrwlCompilation, SourceComponent> fetch) {
            this.fetchers.add(fetch);
            return this;
        }

        public Builder<K> withLoader(BiFunction<K, ShaderSources, SourceComponent> fetch) {
            return this.with((k, c) -> (SourceComponent)fetch.apply(k, c.getLoader()));
        }

        public Builder<K> withComponent(SourceComponent component) {
            return this.with((key, $) -> component);
        }

        public Builder<K> withComponent(Function<K, SourceComponent> sourceFetcher) {
            return this.with((key, $) -> (SourceComponent)sourceFetcher.apply(key));
        }

        public Builder<K> withResource(class_2960 rl) {
            return this.withResource((K $) -> rl);
        }

        public Builder<K> withResource(Function<K, class_2960> sourceFetcher) {
            return this.withLoader((key, loader) -> loader.get((class_2960)sourceFetcher.apply(key)));
        }

        public Builder<K> onCompile(BiConsumer<K, ClrwlCompilation> cb) {
            this.compileCallbacks = this.compileCallbacks.andThen(cb);
            return this;
        }

        public ClrwlPipelineStage<K> build() {
            Objects.requireNonNull(this.type);
            Objects.requireNonNull(this.extensions);
            Objects.requireNonNull(this.defines);
            Objects.requireNonNull(this.fetchers);
            Objects.requireNonNull(this.compileCallbacks);
            return new ClrwlPipelineStage<K>(this.type, this.extensions, this.defines, this.fetchers, this.compileCallbacks);
        }
    }
}

