/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.mixin.iris;

import dev.djefrey.colorwheel.ShaderType;
import dev.djefrey.colorwheel.accessors.ProgramSourceAccessor;
import dev.djefrey.colorwheel.compile.transform.ClrwlTransformPatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import net.irisshaders.iris.gl.blending.BlendModeOverride;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.irisshaders.iris.shaderpack.programs.ProgramSource;
import net.irisshaders.iris.shaderpack.properties.ShaderProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ProgramSource.class})
public class ProgramSourceMixin
implements ProgramSourceAccessor {
    @Unique
    ShaderProperties colorwheel$shaderProperties;
    @Unique
    BlendModeOverride colorwheel$blendMode;
    @Unique
    Map<ShaderType, Integer> colorwheel$shaderVersions;
    @Unique
    Map<ShaderType, List<String>> colorwheel$shaderExtensions;

    @Override
    public ShaderProperties colorwheel$getShaderProperties() {
        return this.colorwheel$shaderProperties;
    }

    @Override
    public BlendModeOverride colorwheel$getBlendModeOverride() {
        return this.colorwheel$blendMode;
    }

    @Override
    public Optional<Integer> colorwheel$getShaderVersion(ShaderType type) {
        return Optional.ofNullable(this.colorwheel$shaderVersions.get((Object)type));
    }

    @Override
    public Map<ShaderType, List<String>> colorwheel$getShaderExtensions() {
        return this.colorwheel$shaderExtensions;
    }

    @Inject(method={"<init>(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lnet/irisshaders/iris/shaderpack/programs/ProgramSet;Lnet/irisshaders/iris/shaderpack/properties/ShaderProperties;Lnet/irisshaders/iris/gl/blending/BlendModeOverride;)V"}, at={@At(value="TAIL")})
    private void injectInit(String name, String vertex, String geometry, String tess, String tessEval, String fragment, ProgramSet programs, ShaderProperties properties, BlendModeOverride blendModeOverride, CallbackInfo ci) {
        this.colorwheel$shaderVersions = new HashMap<ShaderType, Integer>();
        this.colorwheel$parseShaderVersion(vertex).ifPresent(v -> this.colorwheel$shaderVersions.put(ShaderType.VERTEX, (Integer)v));
        this.colorwheel$parseShaderVersion(geometry).ifPresent(v -> this.colorwheel$shaderVersions.put(ShaderType.GEOMETRY, (Integer)v));
        this.colorwheel$parseShaderVersion(fragment).ifPresent(v -> this.colorwheel$shaderVersions.put(ShaderType.FRAGMENT, (Integer)v));
        this.colorwheel$shaderExtensions = Map.of(ShaderType.VERTEX, this.colorwheel$parseShaderExtensions(vertex), ShaderType.GEOMETRY, this.colorwheel$parseShaderExtensions(geometry), ShaderType.FRAGMENT, this.colorwheel$parseShaderExtensions(fragment));
        this.colorwheel$shaderProperties = properties;
        this.colorwheel$blendMode = blendModeOverride;
    }

    @Unique
    private Optional<Integer> colorwheel$parseShaderVersion(String str) {
        if (str == null) {
            return Optional.empty();
        }
        Iterator it = str.lines().iterator();
        while (it.hasNext()) {
            String line = (String)it.next();
            Matcher matcher = ClrwlTransformPatcher.versionPattern.matcher(line);
            if (!matcher.matches()) continue;
            return Optional.of(Integer.parseInt(matcher.group(1)));
        }
        return Optional.empty();
    }

    @Unique
    private List<String> colorwheel$parseShaderExtensions(String str) {
        ArrayList<String> res = new ArrayList<String>();
        if (str == null) {
            return res;
        }
        str.lines().forEach(line -> {
            if ((line = line.trim()).startsWith("#extension ") && line.contains(":")) {
                String name = line.substring(11).split(":")[0].trim();
                res.add(name);
            }
        });
        return res;
    }
}

