/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.compile;

import com.google.common.collect.ImmutableSet;
import dev.djefrey.colorwheel.ClrwlSamplers;
import dev.djefrey.colorwheel.Colorwheel;
import dev.djefrey.colorwheel.compile.ClrwlProgramSource;
import dev.djefrey.colorwheel.engine.ClrwlBlendModeOverride;
import dev.djefrey.colorwheel.engine.ClrwlInstanceVisual;
import dev.djefrey.colorwheel.engine.ClrwlMaterialEncoder;
import dev.djefrey.colorwheel.engine.ClrwlRenderingPhase;
import dev.djefrey.colorwheel.engine.uniform.ClrwlUniforms;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramGroup;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramId;
import dev.djefrey.colorwheel.shaderpack.ClrwlShaderProperties;
import dev.djefrey.colorwheel.util.Utils;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.material.Transparency;
import dev.engine_room.flywheel.backend.gl.shader.GlProgram;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.irisshaders.iris.gl.blending.BlendMode;
import net.irisshaders.iris.gl.image.ImageHolder;
import net.irisshaders.iris.gl.program.ProgramImages;
import net.irisshaders.iris.gl.program.ProgramSamplers;
import net.irisshaders.iris.gl.program.ProgramUniforms;
import net.irisshaders.iris.gl.sampler.SamplerHolder;
import net.irisshaders.iris.gl.shader.GlShader;
import net.irisshaders.iris.gl.shader.ShaderType;
import net.irisshaders.iris.gl.state.FogMode;
import net.irisshaders.iris.gl.uniform.DynamicUniformHolder;
import net.irisshaders.iris.gl.uniform.LocationalUniformHolder;
import net.irisshaders.iris.mixin.texture.TextureAtlasAccessor;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.uniforms.CommonUniforms;
import net.irisshaders.iris.uniforms.custom.CustomUniforms;
import net.minecraft.class_1044;
import net.minecraft.class_1059;
import net.minecraft.class_285;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL31;

public class ClrwlProgram {
    private final GlShader vertex;
    @Nullable
    private final GlShader geometry;
    private final GlShader fragment;
    private final int handle;
    private final ProgramUniforms uniforms;
    private final CustomUniforms customUniforms;
    private final ProgramSamplers samplers;
    private final ProgramImages images;
    public final int vertexOffsetUniform;
    public final int baseInstanceUniform;
    public final int packedMaterialUniform;
    public final int modelMatrixUniform;
    public final int normalMatrixUniform;
    public final int blockEntityUniform;
    public final int entityUniform;
    public final int meshCenterUniform;
    public final int renderPhaseUniform;
    public final int blendFuncUniform;
    public final int atlasSizeUniform;

    public static ImmutableSet<Integer> getReservedTextureUnits(int coeffCount) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        res.add(ClrwlSamplers.DIFFUSE.number);
        res.add(ClrwlSamplers.OVERLAY.number);
        res.add(ClrwlSamplers.LIGHT.number);
        res.add(ClrwlSamplers.CRUMBLING.number);
        res.add(ClrwlSamplers.INSTANCE_BUFFER.number);
        res.add(ClrwlSamplers.LIGHT_LUT.number);
        res.add(ClrwlSamplers.LIGHT_SECTIONS.number);
        res.add(ClrwlSamplers.DEPTH_RANGE.number);
        res.add(ClrwlSamplers.NOISE.number);
        for (int i = 0; i < coeffCount; ++i) {
            res.add(ClrwlSamplers.getCoefficient((int)i).number);
        }
        return ImmutableSet.copyOf(res);
    }

    private ClrwlProgram(String name, ClrwlProgramId programId, ClrwlShaderProperties properties, String vertex, Optional<String> geometry, String fragment, CustomUniforms customUniforms, IrisRenderingPipeline pipeline) {
        boolean isShadowPass;
        this.vertex = new GlShader(ShaderType.VERTEX, name + ".vsh", vertex);
        this.geometry = geometry.map(sh -> new GlShader(ShaderType.GEOMETRY, name + ".gsh", sh)).orElse(null);
        this.fragment = new GlShader(ShaderType.FRAGMENT, name + ".fsh", fragment);
        this.handle = GL20.glCreateProgram();
        GL20.glAttachShader((int)this.handle, (int)this.vertex.getHandle());
        if (this.geometry != null) {
            GL20.glAttachShader((int)this.handle, (int)this.geometry.getHandle());
        }
        GL20.glAttachShader((int)this.handle, (int)this.fragment.getHandle());
        GL20.glBindAttribLocation((int)this.handle, (int)0, (CharSequence)"_flw_aPos");
        GL20.glBindAttribLocation((int)this.handle, (int)1, (CharSequence)"_flw_aColor");
        GL20.glBindAttribLocation((int)this.handle, (int)2, (CharSequence)"_flw_aTexCoord");
        GL20.glBindAttribLocation((int)this.handle, (int)3, (CharSequence)"_flw_aLight");
        GL20.glBindAttribLocation((int)this.handle, (int)4, (CharSequence)"_flw_aNormal");
        GL20.glBindAttribLocation((int)this.handle, (int)5, (CharSequence)"_clrwl_aEntity");
        GL20.glBindAttribLocation((int)this.handle, (int)6, (CharSequence)"_clrwl_aMidTexCoord");
        GL20.glBindAttribLocation((int)this.handle, (int)7, (CharSequence)"_clrwl_aTangent");
        GL20.glBindAttribLocation((int)this.handle, (int)8, (CharSequence)"_clrwl_aMidBlock");
        GL20.glBindAttribLocation((int)this.handle, (int)9, (CharSequence)"_flw_aOverlay");
        GL20.glLinkProgram((int)this.handle);
        if (GL20.glGetProgrami((int)this.handle, (int)35714) != 1) {
            RuntimeException err = new RuntimeException("Shader link error in Colorwheel program: " + GL20.glGetProgramInfoLog((int)this.handle));
            GL20.glDeleteProgram((int)this.handle);
            this.vertex.destroy();
            if (this.geometry != null) {
                this.geometry.destroy();
            }
            this.fragment.destroy();
            throw err;
        }
        int[] oitCoeffs = properties.getOitCoeffRanks(programId.group());
        ProgramUniforms.Builder uniformBuilder = ProgramUniforms.builder((String)name, (int)this.handle);
        ProgramSamplers.Builder samplerBuilder = ProgramSamplers.builder((int)this.handle, ClrwlProgram.getReservedTextureUnits(oitCoeffs.length));
        ProgramImages.Builder imageBuilder = ProgramImages.builder((int)this.handle);
        samplerBuilder.addExternalSampler(ClrwlSamplers.DIFFUSE.number, new String[]{"flw_diffuseTex"});
        samplerBuilder.addExternalSampler(ClrwlSamplers.OVERLAY.number, new String[]{"flw_overlayTex"});
        samplerBuilder.addExternalSampler(ClrwlSamplers.CRUMBLING.number, new String[]{"_flw_crumblingTex"});
        samplerBuilder.addExternalSampler(ClrwlSamplers.INSTANCE_BUFFER.number, new String[]{"_flw_instances"});
        samplerBuilder.addExternalSampler(ClrwlSamplers.LIGHT_LUT.number, new String[]{"_flw_lightLut"});
        samplerBuilder.addExternalSampler(ClrwlSamplers.LIGHT_SECTIONS.number, new String[]{"_flw_lightSections"});
        samplerBuilder.addExternalSampler(ClrwlSamplers.DEPTH_RANGE.number, new String[]{"_flw_depthRange"});
        samplerBuilder.addExternalSampler(ClrwlSamplers.NOISE.number, new String[]{"_flw_blueNoise"});
        for (int i = 0; i < oitCoeffs.length; ++i) {
            samplerBuilder.addExternalSampler(ClrwlSamplers.getCoefficient((int)i).number, new String[]{"clrwl_coefficients" + i});
        }
        boolean bl = isShadowPass = programId.group() == ClrwlProgramGroup.SHADOW;
        Supplier<ImmutableSet> flipped = isShadowPass ? () -> ((IrisRenderingPipeline)pipeline).getFlippedBeforeShadow() : (programId.afterTranslucent() ? () -> ((IrisRenderingPipeline)pipeline).getFlippedAfterTranslucent() : () -> ((IrisRenderingPipeline)pipeline).getFlippedAfterPrepare());
        CommonUniforms.addDynamicUniforms((DynamicUniformHolder)uniformBuilder, (FogMode)FogMode.PER_VERTEX);
        customUniforms.assignTo((LocationalUniformHolder)uniformBuilder);
        pipeline.addGbufferOrShadowSamplers((SamplerHolder)samplerBuilder, (ImageHolder)imageBuilder, flipped, isShadowPass, false, true, false);
        customUniforms.mapholderToPass((LocationalUniformHolder)uniformBuilder, (Object)this);
        this.uniforms = uniformBuilder.buildUniforms();
        this.customUniforms = customUniforms;
        this.samplers = samplerBuilder.build();
        this.images = imageBuilder.build();
        this.vertexOffsetUniform = this.tryGetUniformLocation2("_flw_vertexOffset");
        this.baseInstanceUniform = this.tryGetUniformLocation2("_flw_baseInstance");
        this.packedMaterialUniform = this.tryGetUniformLocation2("_clrwl_packedMaterial");
        this.modelMatrixUniform = this.tryGetUniformLocation2("_flw_modelMatrixUniform");
        this.normalMatrixUniform = this.tryGetUniformLocation2("_flw_normalMatrixUniform");
        this.blockEntityUniform = this.tryGetUniformLocation2("_clrwl_blockEntityId");
        this.entityUniform = this.tryGetUniformLocation2("_clrwl_entityId");
        this.meshCenterUniform = this.tryGetUniformLocation2("_clrwl_meshCenter");
        this.renderPhaseUniform = this.tryGetUniformLocation2("_clrwl_renderPhase");
        this.blendFuncUniform = this.tryGetUniformLocation2("_clrwl_blendFunc");
        this.atlasSizeUniform = this.tryGetUniformLocation2("_clrwl_atlasSize");
        ClrwlUniforms.setUniformBlockBinding(this);
    }

    private int tryGetUniformLocation2(CharSequence name) {
        return GL20.glGetUniformLocation((int)this.handle, (CharSequence)name);
    }

    public static ClrwlProgram createProgram(String name, ClrwlProgramId programId, ClrwlProgramSource source, ClrwlShaderProperties properties, CustomUniforms customUniforms, IrisRenderingPipeline pipeline) {
        return new ClrwlProgram(name, programId, properties, source.vertex(), source.geometry(), source.fragment(), customUniforms, pipeline);
    }

    public void bind(int vertexOffset, int baseInstance, Material material, ClrwlInstanceVisual visual, Vector3fc meshCenter, ClrwlRenderingPhase phase, ClrwlBlendModeOverride blendModeOverride) {
        class_285.method_22094((int)this.handle);
        int packedMaterialProperties = ClrwlMaterialEncoder.packProperties(material);
        class_1044 abstractTexture = class_310.method_1551().method_1531().method_4619(material.texture());
        int atlasWidth = 0;
        int atlasHeight = 0;
        if (abstractTexture instanceof class_1059) {
            class_1059 atlas = (class_1059)abstractTexture;
            atlasWidth = ((TextureAtlasAccessor)atlas).callGetWidth();
            atlasHeight = ((TextureAtlasAccessor)atlas).callGetWidth();
        }
        BlendMode blendMode = blendModeOverride != null ? (blendModeOverride.blendMode() != null ? blendModeOverride.blendMode() : Utils.transparencyToBlendMode(Transparency.OPAQUE)) : Utils.transparencyToBlendMode(material.transparency());
        this.setUniformU(this.vertexOffsetUniform, vertexOffset);
        this.setUniformS(this.baseInstanceUniform, baseInstance);
        this.setUniformU(this.packedMaterialUniform, packedMaterialProperties);
        this.setUniformS(this.blockEntityUniform, visual.getBlockEntity());
        this.setUniformS(this.entityUniform, visual.getEntity());
        this.setUniform(this.meshCenterUniform, meshCenter.x(), meshCenter.y(), meshCenter.z(), visual.lightEmission());
        this.setUniformS(this.renderPhaseUniform, phase.getValue());
        this.setUniformI(this.blendFuncUniform, blendMode.srcRgb(), blendMode.dstRgb(), blendMode.srcAlpha(), blendMode.dstAlpha());
        this.setUniformI(this.atlasSizeUniform, atlasWidth, atlasHeight);
        this.samplers.update();
        this.uniforms.update();
        this.customUniforms.push((Object)this);
        this.images.update();
    }

    public void unbind() {
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
    }

    public void setEmbeddedMatrices(Matrix4f model, Matrix3f normal) {
        if (this.modelMatrixUniform != -1) {
            this.setUniform(this.modelMatrixUniform, model);
        }
        if (this.normalMatrixUniform != -1) {
            this.setUniform(this.modelMatrixUniform, normal);
        }
    }

    public void setUniformBlockBinding(String name, int binding) {
        int index = GL31.glGetUniformBlockIndex((int)this.handle, (CharSequence)name);
        if (index == -1) {
            Colorwheel.LOGGER.debug("No uniform block for {}", (Object)name);
            return;
        }
        GL31.glUniformBlockBinding((int)this.handle, (int)index, (int)binding);
    }

    public void free() {
        GL31.glDeleteProgram((int)this.handle);
        this.vertex.destroy();
        this.fragment.destroy();
    }

    private void setUniformS(int index, int i) {
        GL31.glUniform1i((int)index, (int)i);
    }

    private void setUniformU(int index, int i) {
        GL31.glUniform1ui((int)index, (int)i);
    }

    private void setUniformI(int index, int x, int y) {
        GL31.glUniform2i((int)index, (int)x, (int)y);
    }

    private void setUniformI(int index, int x, int y, int z, int w) {
        GL31.glUniform4i((int)index, (int)x, (int)y, (int)z, (int)w);
    }

    private void setUniform(int index, float x, float y, float z, float w) {
        GL31.glUniform4f((int)index, (float)x, (float)y, (float)z, (float)w);
    }

    private void setUniform(int index, Matrix3f mat) {
        GL31.glUniformMatrix3fv((int)index, (boolean)false, (float[])mat.get(new float[12]));
    }

    private void setUniform(int index, Matrix4f mat) {
        GL31.glUniformMatrix4fv((int)index, (boolean)false, (float[])mat.get(new float[16]));
    }

    public GlProgram getProgram() {
        return new GlProgram(this.handle);
    }
}

