/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine;

import com.mojang.datafixers.util.Pair;
import dev.djefrey.colorwheel.engine.ClrwlAbstractInstancer;
import dev.djefrey.colorwheel.engine.ClrwlInstanceHandle;
import dev.djefrey.colorwheel.engine.ClrwlInstanceVisual;
import dev.djefrey.colorwheel.engine.ClrwlInstancerKey;
import dev.djefrey.colorwheel.engine.embed.EnvironmentStorage;
import dev.engine_room.flywheel.api.backend.Engine;
import dev.engine_room.flywheel.api.backend.RenderContext;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.InstanceHandle;
import dev.engine_room.flywheel.api.instance.InstanceType;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.task.Plan;
import dev.engine_room.flywheel.backend.FlwBackend;
import dev.engine_room.flywheel.backend.engine.GroupKey;
import dev.engine_room.flywheel.backend.engine.LightStorage;
import dev.engine_room.flywheel.backend.engine.embed.Environment;
import dev.engine_room.flywheel.lib.task.ForEachPlan;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1088;
import org.jetbrains.annotations.Nullable;

public abstract class ClrwlDrawManager<N extends ClrwlAbstractInstancer<?>> {
    private static final boolean WARN_EMPTY_MODELS = Boolean.getBoolean("flywheel.warnEmptyModels");
    protected final Map<ClrwlInstancerKey<?>, N> instancers = new ConcurrentHashMap();
    protected final Queue<UninitializedInstancer<N, ?>> initializationQueue = new ConcurrentLinkedQueue();

    public <I extends Instance> ClrwlAbstractInstancer<I> getInstancer(ClrwlInstanceVisual visual, Environment environment, InstanceType<I> type, Model model, int bias) {
        return this.getInstancer(new ClrwlInstancerKey<I>(visual, environment, type, model, bias));
    }

    public <I extends Instance> ClrwlAbstractInstancer<I> getInstancer(ClrwlInstancerKey<I> key) {
        return this.instancers.computeIfAbsent(key, this::createAndDeferInit);
    }

    public Plan<RenderContext> createFramePlan() {
        return ForEachPlan.of(() -> new ArrayList<N>(this.instancers.values()), ClrwlAbstractInstancer::parallelUpdate);
    }

    public void prepareFrame(LightStorage lightStorage, EnvironmentStorage environmentStorage) {
        for (UninitializedInstancer uninitializedInstancer : this.initializationQueue) {
            ClrwlAbstractInstancer instancer = (ClrwlAbstractInstancer)uninitializedInstancer.instancer();
            if (instancer.instanceCount() > 0) {
                this.initialize(uninitializedInstancer.key(), instancer);
                continue;
            }
            this.instancers.remove(uninitializedInstancer.key());
        }
        this.initializationQueue.clear();
    }

    public abstract void renderSolid();

    public abstract void renderTranslucent();

    public void onRenderOriginChanged() {
        this.instancers.values().forEach(ClrwlAbstractInstancer::clear);
    }

    public abstract void renderCrumbling(List<Engine.CrumblingBlock> var1);

    protected abstract <I extends Instance> N create(ClrwlInstancerKey<I> var1);

    protected abstract <I extends Instance> void initialize(ClrwlInstancerKey<I> var1, N var2);

    private N createAndDeferInit(ClrwlInstancerKey<?> key) {
        N out = this.create(key);
        if (ClrwlDrawManager.checkAndWarnEmptyModel(key.model())) {
            this.initializationQueue.add(new UninitializedInstancer(key, out));
        }
        return out;
    }

    private static boolean checkAndWarnEmptyModel(Model model) {
        if (!model.meshes().isEmpty()) {
            return true;
        }
        if (WARN_EMPTY_MODELS) {
            StringBuilder builder = new StringBuilder();
            builder.append("Creating an instancer for a model with no meshes! Stack trace:");
            StackWalker.getInstance().forEach(f -> builder.append("\n\t").append(f.toString()));
            FlwBackend.LOGGER.warn(builder.toString());
        }
        return false;
    }

    protected static <I extends ClrwlAbstractInstancer<?>> Map<GroupKey<?>, Int2ObjectMap<List<Pair<I, ClrwlInstanceHandle<?>>>>> doCrumblingSort(List<Engine.CrumblingBlock> crumblingBlocks, State2Instancer<I> cast) {
        HashMap byType = new HashMap();
        for (Engine.CrumblingBlock block : crumblingBlocks) {
            int progress = block.progress();
            if (progress < 0 || progress >= class_1088.field_21772.size()) continue;
            for (Instance instance : block.instances()) {
                InstanceHandle instanceHandle = instance.handle();
                if (!(instanceHandle instanceof ClrwlInstanceHandle)) continue;
                ClrwlInstanceHandle impl = (ClrwlInstanceHandle)instanceHandle;
                I instancer = cast.apply(impl.state);
                if (instancer == null) continue;
                ((List)byType.computeIfAbsent(new GroupKey(((ClrwlAbstractInstancer)instancer).type, ((ClrwlAbstractInstancer)instancer).environment), $ -> new Int2ObjectArrayMap()).computeIfAbsent(progress, $ -> new ArrayList())).add(Pair.of(instancer, (Object)impl));
            }
        }
        return byType;
    }

    public void delete() {
        this.instancers.clear();
        this.initializationQueue.clear();
    }

    public abstract void triggerFallback();

    protected record UninitializedInstancer<N, I extends Instance>(ClrwlInstancerKey<I> key, N instancer) {
    }

    @FunctionalInterface
    protected static interface State2Instancer<I extends ClrwlAbstractInstancer<?>> {
        @Nullable
        public I apply(ClrwlInstanceHandle.State<?> var1);
    }
}

